/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummary;
import software.amazon.awssdk.services.licensemanager.model.ConsumedLicenseSummaryListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseCountingType;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary;
import software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummaryListCopier;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.services.licensemanager.model.Tag;
import software.amazon.awssdk.services.licensemanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLicenseConfigurationResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, GetLicenseConfigurationResponse> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseConfigurationId)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationId").build()}).build();
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseConfigurationArn)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::name)).setter(GetLicenseConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::description)).setter(GetLicenseConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LICENSE_COUNTING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseCountingTypeAsString)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseCountingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountingType").build()}).build();
    private static final SdkField<List<String>> LICENSE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseRules)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LICENSE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseCount)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCount").build()}).build();
    private static final SdkField<Boolean> LICENSE_COUNT_HARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::licenseCountHardLimit)).setter(GetLicenseConfigurationResponse.setter(Builder::licenseCountHardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseCountHardLimit").build()}).build();
    private static final SdkField<Long> CONSUMED_LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::consumedLicenses)).setter(GetLicenseConfigurationResponse.setter(Builder::consumedLicenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenses").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::status)).setter(GetLicenseConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::ownerAccountId)).setter(GetLicenseConfigurationResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<List<ConsumedLicenseSummary>> CONSUMED_LICENSE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::consumedLicenseSummaryList)).setter(GetLicenseConfigurationResponse.setter(Builder::consumedLicenseSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLicenseSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedLicenseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedResourceSummary>> MANAGED_RESOURCE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::managedResourceSummaryList)).setter(GetLicenseConfigurationResponse.setter(Builder::managedResourceSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedResourceSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLicenseConfigurationResponse.getter(GetLicenseConfigurationResponse::tags)).setter(GetLicenseConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_CONFIGURATION_ID_FIELD, LICENSE_CONFIGURATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LICENSE_COUNTING_TYPE_FIELD, LICENSE_RULES_FIELD, LICENSE_COUNT_FIELD, LICENSE_COUNT_HARD_LIMIT_FIELD, CONSUMED_LICENSES_FIELD, STATUS_FIELD, OWNER_ACCOUNT_ID_FIELD, CONSUMED_LICENSE_SUMMARY_LIST_FIELD, MANAGED_RESOURCE_SUMMARY_LIST_FIELD, TAGS_FIELD));
    private final String licenseConfigurationId;
    private final String licenseConfigurationArn;
    private final String name;
    private final String description;
    private final String licenseCountingType;
    private final List<String> licenseRules;
    private final Long licenseCount;
    private final Boolean licenseCountHardLimit;
    private final Long consumedLicenses;
    private final String status;
    private final String ownerAccountId;
    private final List<ConsumedLicenseSummary> consumedLicenseSummaryList;
    private final List<ManagedResourceSummary> managedResourceSummaryList;
    private final List<Tag> tags;

    private GetLicenseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.licenseConfigurationId = builder.licenseConfigurationId;
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.licenseCountingType = builder.licenseCountingType;
        this.licenseRules = builder.licenseRules;
        this.licenseCount = builder.licenseCount;
        this.licenseCountHardLimit = builder.licenseCountHardLimit;
        this.consumedLicenses = builder.consumedLicenses;
        this.status = builder.status;
        this.ownerAccountId = builder.ownerAccountId;
        this.consumedLicenseSummaryList = builder.consumedLicenseSummaryList;
        this.managedResourceSummaryList = builder.managedResourceSummaryList;
        this.tags = builder.tags;
    }

    public String licenseConfigurationId() {
        return this.licenseConfigurationId;
    }

    public String licenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public LicenseCountingType licenseCountingType() {
        return LicenseCountingType.fromValue(this.licenseCountingType);
    }

    public String licenseCountingTypeAsString() {
        return this.licenseCountingType;
    }

    public List<String> licenseRules() {
        return this.licenseRules;
    }

    public Long licenseCount() {
        return this.licenseCount;
    }

    public Boolean licenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public Long consumedLicenses() {
        return this.consumedLicenses;
    }

    public String status() {
        return this.status;
    }

    public String ownerAccountId() {
        return this.ownerAccountId;
    }

    public List<ConsumedLicenseSummary> consumedLicenseSummaryList() {
        return this.consumedLicenseSummaryList;
    }

    public List<ManagedResourceSummary> managedResourceSummaryList() {
        return this.managedResourceSummaryList;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseCountHardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedLicenses());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedLicenseSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedResourceSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseConfigurationResponse)) {
            return false;
        }
        GetLicenseConfigurationResponse other = (GetLicenseConfigurationResponse)((Object)obj);
        return Objects.equals(this.licenseConfigurationId(), other.licenseConfigurationId()) && Objects.equals(this.licenseConfigurationArn(), other.licenseConfigurationArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.licenseCountingTypeAsString(), other.licenseCountingTypeAsString()) && Objects.equals(this.licenseRules(), other.licenseRules()) && Objects.equals(this.licenseCount(), other.licenseCount()) && Objects.equals(this.licenseCountHardLimit(), other.licenseCountHardLimit()) && Objects.equals(this.consumedLicenses(), other.consumedLicenses()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.consumedLicenseSummaryList(), other.consumedLicenseSummaryList()) && Objects.equals(this.managedResourceSummaryList(), other.managedResourceSummaryList()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetLicenseConfigurationResponse").add("LicenseConfigurationId", (Object)this.licenseConfigurationId()).add("LicenseConfigurationArn", (Object)this.licenseConfigurationArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LicenseCountingType", (Object)this.licenseCountingTypeAsString()).add("LicenseRules", this.licenseRules()).add("LicenseCount", (Object)this.licenseCount()).add("LicenseCountHardLimit", (Object)this.licenseCountHardLimit()).add("ConsumedLicenses", (Object)this.consumedLicenses()).add("Status", (Object)this.status()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ConsumedLicenseSummaryList", this.consumedLicenseSummaryList()).add("ManagedResourceSummaryList", this.managedResourceSummaryList()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationId()));
            }
            case "LicenseConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.licenseConfigurationArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseCountingType": {
                return Optional.ofNullable(clazz.cast(this.licenseCountingTypeAsString()));
            }
            case "LicenseRules": {
                return Optional.ofNullable(clazz.cast(this.licenseRules()));
            }
            case "LicenseCount": {
                return Optional.ofNullable(clazz.cast(this.licenseCount()));
            }
            case "LicenseCountHardLimit": {
                return Optional.ofNullable(clazz.cast(this.licenseCountHardLimit()));
            }
            case "ConsumedLicenses": {
                return Optional.ofNullable(clazz.cast(this.consumedLicenses()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "ConsumedLicenseSummaryList": {
                return Optional.ofNullable(clazz.cast(this.consumedLicenseSummaryList()));
            }
            case "ManagedResourceSummaryList": {
                return Optional.ofNullable(clazz.cast(this.managedResourceSummaryList()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseConfigurationResponse, T> g) {
        return obj -> g.apply((GetLicenseConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String licenseConfigurationId;
        private String licenseConfigurationArn;
        private String name;
        private String description;
        private String licenseCountingType;
        private List<String> licenseRules = DefaultSdkAutoConstructList.getInstance();
        private Long licenseCount;
        private Boolean licenseCountHardLimit;
        private Long consumedLicenses;
        private String status;
        private String ownerAccountId;
        private List<ConsumedLicenseSummary> consumedLicenseSummaryList = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedResourceSummary> managedResourceSummaryList = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseConfigurationResponse model) {
            super(model);
            this.licenseConfigurationId(model.licenseConfigurationId);
            this.licenseConfigurationArn(model.licenseConfigurationArn);
            this.name(model.name);
            this.description(model.description);
            this.licenseCountingType(model.licenseCountingType);
            this.licenseRules(model.licenseRules);
            this.licenseCount(model.licenseCount);
            this.licenseCountHardLimit(model.licenseCountHardLimit);
            this.consumedLicenses(model.consumedLicenses);
            this.status(model.status);
            this.ownerAccountId(model.ownerAccountId);
            this.consumedLicenseSummaryList(model.consumedLicenseSummaryList);
            this.managedResourceSummaryList(model.managedResourceSummaryList);
            this.tags(model.tags);
        }

        public final String getLicenseConfigurationId() {
            return this.licenseConfigurationId;
        }

        @Override
        public final Builder licenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
            return this;
        }

        public final void setLicenseConfigurationId(String licenseConfigurationId) {
            this.licenseConfigurationId = licenseConfigurationId;
        }

        public final String getLicenseConfigurationArn() {
            return this.licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLicenseCountingTypeAsString() {
            return this.licenseCountingType;
        }

        @Override
        public final Builder licenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
            return this;
        }

        @Override
        public final Builder licenseCountingType(LicenseCountingType licenseCountingType) {
            this.licenseCountingType(licenseCountingType.toString());
            return this;
        }

        public final void setLicenseCountingType(String licenseCountingType) {
            this.licenseCountingType = licenseCountingType;
        }

        public final Collection<String> getLicenseRules() {
            return this.licenseRules;
        }

        @Override
        public final Builder licenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRules(String ... licenseRules) {
            this.licenseRules(Arrays.asList(licenseRules));
            return this;
        }

        public final void setLicenseRules(Collection<String> licenseRules) {
            this.licenseRules = StringListCopier.copy(licenseRules);
        }

        public final Long getLicenseCount() {
            return this.licenseCount;
        }

        @Override
        public final Builder licenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
            return this;
        }

        public final void setLicenseCount(Long licenseCount) {
            this.licenseCount = licenseCount;
        }

        public final Boolean getLicenseCountHardLimit() {
            return this.licenseCountHardLimit;
        }

        @Override
        public final Builder licenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
            return this;
        }

        public final void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
            this.licenseCountHardLimit = licenseCountHardLimit;
        }

        public final Long getConsumedLicenses() {
            return this.consumedLicenses;
        }

        @Override
        public final Builder consumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
            return this;
        }

        public final void setConsumedLicenses(Long consumedLicenses) {
            this.consumedLicenses = consumedLicenses;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        public final Collection<ConsumedLicenseSummary.Builder> getConsumedLicenseSummaryList() {
            return this.consumedLicenseSummaryList != null ? (Collection)this.consumedLicenseSummaryList.stream().map(ConsumedLicenseSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copy(consumedLicenseSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(ConsumedLicenseSummary ... consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList(Arrays.asList(consumedLicenseSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder> ... consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList(Stream.of(consumedLicenseSummaryList).map(c -> (ConsumedLicenseSummary)((ConsumedLicenseSummary.Builder)ConsumedLicenseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedLicenseSummaryList(Collection<ConsumedLicenseSummary.BuilderImpl> consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList = ConsumedLicenseSummaryListCopier.copyFromBuilder(consumedLicenseSummaryList);
        }

        public final Collection<ManagedResourceSummary.Builder> getManagedResourceSummaryList() {
            return this.managedResourceSummaryList != null ? (Collection)this.managedResourceSummaryList.stream().map(ManagedResourceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copy(managedResourceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedResourceSummaryList(ManagedResourceSummary ... managedResourceSummaryList) {
            this.managedResourceSummaryList(Arrays.asList(managedResourceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder> ... managedResourceSummaryList) {
            this.managedResourceSummaryList(Stream.of(managedResourceSummaryList).map(c -> (ManagedResourceSummary)((ManagedResourceSummary.Builder)ManagedResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setManagedResourceSummaryList(Collection<ManagedResourceSummary.BuilderImpl> managedResourceSummaryList) {
            this.managedResourceSummaryList = ManagedResourceSummaryListCopier.copyFromBuilder(managedResourceSummaryList);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public GetLicenseConfigurationResponse build() {
            return new GetLicenseConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLicenseConfigurationResponse> {
        public Builder licenseConfigurationId(String var1);

        public Builder licenseConfigurationArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder licenseCountingType(String var1);

        public Builder licenseCountingType(LicenseCountingType var1);

        public Builder licenseRules(Collection<String> var1);

        public Builder licenseRules(String ... var1);

        public Builder licenseCount(Long var1);

        public Builder licenseCountHardLimit(Boolean var1);

        public Builder consumedLicenses(Long var1);

        public Builder status(String var1);

        public Builder ownerAccountId(String var1);

        public Builder consumedLicenseSummaryList(Collection<ConsumedLicenseSummary> var1);

        public Builder consumedLicenseSummaryList(ConsumedLicenseSummary ... var1);

        public Builder consumedLicenseSummaryList(Consumer<ConsumedLicenseSummary.Builder> ... var1);

        public Builder managedResourceSummaryList(Collection<ManagedResourceSummary> var1);

        public Builder managedResourceSummaryList(ManagedResourceSummary ... var1);

        public Builder managedResourceSummaryList(Consumer<ManagedResourceSummary.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

