/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ResourceType;
import software.amazon.awssdk.services.licensemanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceInventory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceInventory> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceInventory.getter(ResourceInventory::resourceId)).setter(ResourceInventory.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceInventory.getter(ResourceInventory::resourceTypeAsString)).setter(ResourceInventory.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ResourceInventory.getter(ResourceInventory::resourceArn)).setter(ResourceInventory.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ResourceInventory.getter(ResourceInventory::platform)).setter(ResourceInventory.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(ResourceInventory.getter(ResourceInventory::platformVersion)).setter(ResourceInventory.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> RESOURCE_OWNING_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwningAccountId").getter(ResourceInventory.getter(ResourceInventory::resourceOwningAccountId)).setter(ResourceInventory.setter(Builder::resourceOwningAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwningAccountId").build()}).build();
    private static final SdkField<List<String>> MARKETPLACE_PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MarketplaceProductCodes").getter(ResourceInventory.getter(ResourceInventory::marketplaceProductCodes)).setter(ResourceInventory.setter(Builder::marketplaceProductCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceProductCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(ResourceInventory.getter(ResourceInventory::usageOperation)).setter(ResourceInventory.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()}).build();
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiId").getter(ResourceInventory.getter(ResourceInventory::amiId)).setter(ResourceInventory.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostId").getter(ResourceInventory.getter(ResourceInventory::hostId)).setter(ResourceInventory.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ResourceInventory.getter(ResourceInventory::region)).setter(ResourceInventory.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ResourceInventory.getter(ResourceInventory::instanceType)).setter(ResourceInventory.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ARN_FIELD, PLATFORM_FIELD, PLATFORM_VERSION_FIELD, RESOURCE_OWNING_ACCOUNT_ID_FIELD, MARKETPLACE_PRODUCT_CODES_FIELD, USAGE_OPERATION_FIELD, AMI_ID_FIELD, HOST_ID_FIELD, REGION_FIELD, INSTANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceInventory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceType;
    private final String resourceArn;
    private final String platform;
    private final String platformVersion;
    private final String resourceOwningAccountId;
    private final List<String> marketplaceProductCodes;
    private final String usageOperation;
    private final String amiId;
    private final String hostId;
    private final String region;
    private final String instanceType;

    private ResourceInventory(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceArn = builder.resourceArn;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.resourceOwningAccountId = builder.resourceOwningAccountId;
        this.marketplaceProductCodes = builder.marketplaceProductCodes;
        this.usageOperation = builder.usageOperation;
        this.amiId = builder.amiId;
        this.hostId = builder.hostId;
        this.region = builder.region;
        this.instanceType = builder.instanceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String platform() {
        return this.platform;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String resourceOwningAccountId() {
        return this.resourceOwningAccountId;
    }

    public final boolean hasMarketplaceProductCodes() {
        return this.marketplaceProductCodes != null && !(this.marketplaceProductCodes instanceof SdkAutoConstructList);
    }

    public final List<String> marketplaceProductCodes() {
        return this.marketplaceProductCodes;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final String region() {
        return this.region;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwningAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMarketplaceProductCodes() ? this.marketplaceProductCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInventory)) {
            return false;
        }
        ResourceInventory other = (ResourceInventory)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.resourceOwningAccountId(), other.resourceOwningAccountId()) && this.hasMarketplaceProductCodes() == other.hasMarketplaceProductCodes() && Objects.equals(this.marketplaceProductCodes(), other.marketplaceProductCodes()) && Objects.equals(this.usageOperation(), other.usageOperation()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceInventory").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("Platform", (Object)this.platform()).add("PlatformVersion", (Object)this.platformVersion()).add("ResourceOwningAccountId", (Object)this.resourceOwningAccountId()).add("MarketplaceProductCodes", this.hasMarketplaceProductCodes() ? this.marketplaceProductCodes() : null).add("UsageOperation", (Object)this.usageOperation()).add("AmiId", (Object)this.amiId()).add("HostId", (Object)this.hostId()).add("Region", (Object)this.region()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ResourceOwningAccountId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwningAccountId()));
            }
            case "MarketplaceProductCodes": {
                return Optional.ofNullable(clazz.cast(this.marketplaceProductCodes()));
            }
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("PlatformVersion", PLATFORM_VERSION_FIELD);
        map.put("ResourceOwningAccountId", RESOURCE_OWNING_ACCOUNT_ID_FIELD);
        map.put("MarketplaceProductCodes", MARKETPLACE_PRODUCT_CODES_FIELD);
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        map.put("AmiId", AMI_ID_FIELD);
        map.put("HostId", HOST_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceInventory, T> g) {
        return obj -> g.apply((ResourceInventory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String resourceArn;
        private String platform;
        private String platformVersion;
        private String resourceOwningAccountId;
        private List<String> marketplaceProductCodes = DefaultSdkAutoConstructList.getInstance();
        private String usageOperation;
        private String amiId;
        private String hostId;
        private String region;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInventory model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceArn(model.resourceArn);
            this.platform(model.platform);
            this.platformVersion(model.platformVersion);
            this.resourceOwningAccountId(model.resourceOwningAccountId);
            this.marketplaceProductCodes(model.marketplaceProductCodes);
            this.usageOperation(model.usageOperation);
            this.amiId(model.amiId);
            this.hostId(model.hostId);
            this.region(model.region);
            this.instanceType(model.instanceType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getResourceOwningAccountId() {
            return this.resourceOwningAccountId;
        }

        public final void setResourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
        }

        @Override
        public final Builder resourceOwningAccountId(String resourceOwningAccountId) {
            this.resourceOwningAccountId = resourceOwningAccountId;
            return this;
        }

        public final Collection<String> getMarketplaceProductCodes() {
            if (this.marketplaceProductCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.marketplaceProductCodes;
        }

        public final void setMarketplaceProductCodes(Collection<String> marketplaceProductCodes) {
            this.marketplaceProductCodes = StringListCopier.copy(marketplaceProductCodes);
        }

        @Override
        public final Builder marketplaceProductCodes(Collection<String> marketplaceProductCodes) {
            this.marketplaceProductCodes = StringListCopier.copy(marketplaceProductCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder marketplaceProductCodes(String ... marketplaceProductCodes) {
            this.marketplaceProductCodes(Arrays.asList(marketplaceProductCodes));
            return this;
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public ResourceInventory build() {
            return new ResourceInventory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceInventory> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceArn(String var1);

        public Builder platform(String var1);

        public Builder platformVersion(String var1);

        public Builder resourceOwningAccountId(String var1);

        public Builder marketplaceProductCodes(Collection<String> var1);

        public Builder marketplaceProductCodes(String ... var1);

        public Builder usageOperation(String var1);

        public Builder amiId(String var1);

        public Builder hostId(String var1);

        public Builder region(String var1);

        public Builder instanceType(String var1);
    }
}

