/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRule;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseAssetRuleset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseAssetRuleset> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(LicenseAssetRuleset.getter(LicenseAssetRuleset::name)).setter(LicenseAssetRuleset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LicenseAssetRuleset.getter(LicenseAssetRuleset::description)).setter(LicenseAssetRuleset.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<LicenseAssetRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(LicenseAssetRuleset.getter(LicenseAssetRuleset::rules)).setter(LicenseAssetRuleset.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_ASSET_RULESET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAssetRulesetArn").getter(LicenseAssetRuleset.getter(LicenseAssetRuleset::licenseAssetRulesetArn)).setter(LicenseAssetRuleset.setter(Builder::licenseAssetRulesetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetRulesetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RULES_FIELD, LICENSE_ASSET_RULESET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseAssetRuleset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<LicenseAssetRule> rules;
    private final String licenseAssetRulesetArn;

    private LicenseAssetRuleset(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
        this.licenseAssetRulesetArn = builder.licenseAssetRulesetArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetRule> rules() {
        return this.rules;
    }

    public final String licenseAssetRulesetArn() {
        return this.licenseAssetRulesetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAssetRulesetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseAssetRuleset)) {
            return false;
        }
        LicenseAssetRuleset other = (LicenseAssetRuleset)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.licenseAssetRulesetArn(), other.licenseAssetRulesetArn());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseAssetRuleset").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("LicenseAssetRulesetArn", (Object)this.licenseAssetRulesetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "LicenseAssetRulesetArn": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetRulesetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("LicenseAssetRulesetArn", LICENSE_ASSET_RULESET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseAssetRuleset, T> g) {
        return obj -> g.apply((LicenseAssetRuleset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<LicenseAssetRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String licenseAssetRulesetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseAssetRuleset model) {
            this.name(model.name);
            this.description(model.description);
            this.rules(model.rules);
            this.licenseAssetRulesetArn(model.licenseAssetRulesetArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LicenseAssetRule.Builder> getRules() {
            List<LicenseAssetRule.Builder> result = LicenseAssetRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<LicenseAssetRule.BuilderImpl> rules) {
            this.rules = LicenseAssetRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<LicenseAssetRule> rules) {
            this.rules = LicenseAssetRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(LicenseAssetRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<LicenseAssetRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (LicenseAssetRule)((LicenseAssetRule.Builder)LicenseAssetRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLicenseAssetRulesetArn() {
            return this.licenseAssetRulesetArn;
        }

        public final void setLicenseAssetRulesetArn(String licenseAssetRulesetArn) {
            this.licenseAssetRulesetArn = licenseAssetRulesetArn;
        }

        @Override
        public final Builder licenseAssetRulesetArn(String licenseAssetRulesetArn) {
            this.licenseAssetRulesetArn = licenseAssetRulesetArn;
            return this;
        }

        public LicenseAssetRuleset build() {
            return new LicenseAssetRuleset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseAssetRuleset> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder rules(Collection<LicenseAssetRule> var1);

        public Builder rules(LicenseAssetRule ... var1);

        public Builder rules(Consumer<LicenseAssetRule.Builder> ... var1);

        public Builder licenseAssetRulesetArn(String var1);
    }
}

