/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupConfiguration;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupConfigurationListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupProperty;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupPropertyListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRulesetArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseAssetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseAssetGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(LicenseAssetGroup.getter(LicenseAssetGroup::name)).setter(LicenseAssetGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LicenseAssetGroup.getter(LicenseAssetGroup::description)).setter(LicenseAssetGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<LicenseAssetGroupConfiguration>> LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseAssetGroupConfigurations").getter(LicenseAssetGroup.getter(LicenseAssetGroup::licenseAssetGroupConfigurations)).setter(LicenseAssetGroup.setter(Builder::licenseAssetGroupConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedLicenseAssetRulesetARNs").getter(LicenseAssetGroup.getter(LicenseAssetGroup::associatedLicenseAssetRulesetARNs)).setter(LicenseAssetGroup.setter(Builder::associatedLicenseAssetRulesetARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedLicenseAssetRulesetARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LicenseAssetGroupProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(LicenseAssetGroup.getter(LicenseAssetGroup::properties)).setter(LicenseAssetGroup.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetGroupProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_ASSET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAssetGroupArn").getter(LicenseAssetGroup.getter(LicenseAssetGroup::licenseAssetGroupArn)).setter(LicenseAssetGroup.setter(Builder::licenseAssetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LicenseAssetGroup.getter(LicenseAssetGroup::statusAsString)).setter(LicenseAssetGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(LicenseAssetGroup.getter(LicenseAssetGroup::statusMessage)).setter(LicenseAssetGroup.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> LATEST_USAGE_ANALYSIS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestUsageAnalysisTime").getter(LicenseAssetGroup.getter(LicenseAssetGroup::latestUsageAnalysisTime)).setter(LicenseAssetGroup.setter(Builder::latestUsageAnalysisTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUsageAnalysisTime").build()}).build();
    private static final SdkField<Instant> LATEST_RESOURCE_DISCOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestResourceDiscoveryTime").getter(LicenseAssetGroup.getter(LicenseAssetGroup::latestResourceDiscoveryTime)).setter(LicenseAssetGroup.setter(Builder::latestResourceDiscoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestResourceDiscoveryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD, ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD, PROPERTIES_FIELD, LICENSE_ASSET_GROUP_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, LATEST_USAGE_ANALYSIS_TIME_FIELD, LATEST_RESOURCE_DISCOVERY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseAssetGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations;
    private final List<String> associatedLicenseAssetRulesetARNs;
    private final List<LicenseAssetGroupProperty> properties;
    private final String licenseAssetGroupArn;
    private final String status;
    private final String statusMessage;
    private final Instant latestUsageAnalysisTime;
    private final Instant latestResourceDiscoveryTime;

    private LicenseAssetGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.licenseAssetGroupConfigurations = builder.licenseAssetGroupConfigurations;
        this.associatedLicenseAssetRulesetARNs = builder.associatedLicenseAssetRulesetARNs;
        this.properties = builder.properties;
        this.licenseAssetGroupArn = builder.licenseAssetGroupArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.latestUsageAnalysisTime = builder.latestUsageAnalysisTime;
        this.latestResourceDiscoveryTime = builder.latestResourceDiscoveryTime;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLicenseAssetGroupConfigurations() {
        return this.licenseAssetGroupConfigurations != null && !(this.licenseAssetGroupConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations() {
        return this.licenseAssetGroupConfigurations;
    }

    public final boolean hasAssociatedLicenseAssetRulesetARNs() {
        return this.associatedLicenseAssetRulesetARNs != null && !(this.associatedLicenseAssetRulesetARNs instanceof SdkAutoConstructList);
    }

    public final List<String> associatedLicenseAssetRulesetARNs() {
        return this.associatedLicenseAssetRulesetARNs;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetGroupProperty> properties() {
        return this.properties;
    }

    public final String licenseAssetGroupArn() {
        return this.licenseAssetGroupArn;
    }

    public final LicenseAssetGroupStatus status() {
        return LicenseAssetGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant latestUsageAnalysisTime() {
        return this.latestUsageAnalysisTime;
    }

    public final Instant latestResourceDiscoveryTime() {
        return this.latestResourceDiscoveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseAssetGroupConfigurations() ? this.licenseAssetGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedLicenseAssetRulesetARNs() ? this.associatedLicenseAssetRulesetARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAssetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUsageAnalysisTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestResourceDiscoveryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseAssetGroup)) {
            return false;
        }
        LicenseAssetGroup other = (LicenseAssetGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasLicenseAssetGroupConfigurations() == other.hasLicenseAssetGroupConfigurations() && Objects.equals(this.licenseAssetGroupConfigurations(), other.licenseAssetGroupConfigurations()) && this.hasAssociatedLicenseAssetRulesetARNs() == other.hasAssociatedLicenseAssetRulesetARNs() && Objects.equals(this.associatedLicenseAssetRulesetARNs(), other.associatedLicenseAssetRulesetARNs()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.licenseAssetGroupArn(), other.licenseAssetGroupArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.latestUsageAnalysisTime(), other.latestUsageAnalysisTime()) && Objects.equals(this.latestResourceDiscoveryTime(), other.latestResourceDiscoveryTime());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseAssetGroup").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LicenseAssetGroupConfigurations", this.hasLicenseAssetGroupConfigurations() ? this.licenseAssetGroupConfigurations() : null).add("AssociatedLicenseAssetRulesetARNs", this.hasAssociatedLicenseAssetRulesetARNs() ? this.associatedLicenseAssetRulesetARNs() : null).add("Properties", this.hasProperties() ? this.properties() : null).add("LicenseAssetGroupArn", (Object)this.licenseAssetGroupArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("LatestUsageAnalysisTime", (Object)this.latestUsageAnalysisTime()).add("LatestResourceDiscoveryTime", (Object)this.latestResourceDiscoveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LicenseAssetGroupConfigurations": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupConfigurations()));
            }
            case "AssociatedLicenseAssetRulesetARNs": {
                return Optional.ofNullable(clazz.cast(this.associatedLicenseAssetRulesetARNs()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "LicenseAssetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "LatestUsageAnalysisTime": {
                return Optional.ofNullable(clazz.cast(this.latestUsageAnalysisTime()));
            }
            case "LatestResourceDiscoveryTime": {
                return Optional.ofNullable(clazz.cast(this.latestResourceDiscoveryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LicenseAssetGroupConfigurations", LICENSE_ASSET_GROUP_CONFIGURATIONS_FIELD);
        map.put("AssociatedLicenseAssetRulesetARNs", ASSOCIATED_LICENSE_ASSET_RULESET_AR_NS_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        map.put("LicenseAssetGroupArn", LICENSE_ASSET_GROUP_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("LatestUsageAnalysisTime", LATEST_USAGE_ANALYSIS_TIME_FIELD);
        map.put("LatestResourceDiscoveryTime", LATEST_RESOURCE_DISCOVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseAssetGroup, T> g) {
        return obj -> g.apply((LicenseAssetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedLicenseAssetRulesetARNs = DefaultSdkAutoConstructList.getInstance();
        private List<LicenseAssetGroupProperty> properties = DefaultSdkAutoConstructList.getInstance();
        private String licenseAssetGroupArn;
        private String status;
        private String statusMessage;
        private Instant latestUsageAnalysisTime;
        private Instant latestResourceDiscoveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseAssetGroup model) {
            this.name(model.name);
            this.description(model.description);
            this.licenseAssetGroupConfigurations(model.licenseAssetGroupConfigurations);
            this.associatedLicenseAssetRulesetARNs(model.associatedLicenseAssetRulesetARNs);
            this.properties(model.properties);
            this.licenseAssetGroupArn(model.licenseAssetGroupArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.latestUsageAnalysisTime(model.latestUsageAnalysisTime);
            this.latestResourceDiscoveryTime(model.latestResourceDiscoveryTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LicenseAssetGroupConfiguration.Builder> getLicenseAssetGroupConfigurations() {
            List<LicenseAssetGroupConfiguration.Builder> result = LicenseAssetGroupConfigurationListCopier.copyToBuilder(this.licenseAssetGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration.BuilderImpl> licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations = LicenseAssetGroupConfigurationListCopier.copyFromBuilder(licenseAssetGroupConfigurations);
        }

        @Override
        public final Builder licenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration> licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations = LicenseAssetGroupConfigurationListCopier.copy(licenseAssetGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroupConfigurations(LicenseAssetGroupConfiguration ... licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations(Arrays.asList(licenseAssetGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroupConfigurations(Consumer<LicenseAssetGroupConfiguration.Builder> ... licenseAssetGroupConfigurations) {
            this.licenseAssetGroupConfigurations(Stream.of(licenseAssetGroupConfigurations).map(c -> (LicenseAssetGroupConfiguration)((LicenseAssetGroupConfiguration.Builder)LicenseAssetGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedLicenseAssetRulesetARNs() {
            if (this.associatedLicenseAssetRulesetARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedLicenseAssetRulesetARNs;
        }

        public final void setAssociatedLicenseAssetRulesetARNs(Collection<String> associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs = LicenseAssetRulesetArnListCopier.copy(associatedLicenseAssetRulesetARNs);
        }

        @Override
        public final Builder associatedLicenseAssetRulesetARNs(Collection<String> associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs = LicenseAssetRulesetArnListCopier.copy(associatedLicenseAssetRulesetARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedLicenseAssetRulesetARNs(String ... associatedLicenseAssetRulesetARNs) {
            this.associatedLicenseAssetRulesetARNs(Arrays.asList(associatedLicenseAssetRulesetARNs));
            return this;
        }

        public final List<LicenseAssetGroupProperty.Builder> getProperties() {
            List<LicenseAssetGroupProperty.Builder> result = LicenseAssetGroupPropertyListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<LicenseAssetGroupProperty.BuilderImpl> properties) {
            this.properties = LicenseAssetGroupPropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<LicenseAssetGroupProperty> properties) {
            this.properties = LicenseAssetGroupPropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(LicenseAssetGroupProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<LicenseAssetGroupProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (LicenseAssetGroupProperty)((LicenseAssetGroupProperty.Builder)LicenseAssetGroupProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLicenseAssetGroupArn() {
            return this.licenseAssetGroupArn;
        }

        public final void setLicenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
        }

        @Override
        public final Builder licenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseAssetGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getLatestUsageAnalysisTime() {
            return this.latestUsageAnalysisTime;
        }

        public final void setLatestUsageAnalysisTime(Instant latestUsageAnalysisTime) {
            this.latestUsageAnalysisTime = latestUsageAnalysisTime;
        }

        @Override
        public final Builder latestUsageAnalysisTime(Instant latestUsageAnalysisTime) {
            this.latestUsageAnalysisTime = latestUsageAnalysisTime;
            return this;
        }

        public final Instant getLatestResourceDiscoveryTime() {
            return this.latestResourceDiscoveryTime;
        }

        public final void setLatestResourceDiscoveryTime(Instant latestResourceDiscoveryTime) {
            this.latestResourceDiscoveryTime = latestResourceDiscoveryTime;
        }

        @Override
        public final Builder latestResourceDiscoveryTime(Instant latestResourceDiscoveryTime) {
            this.latestResourceDiscoveryTime = latestResourceDiscoveryTime;
            return this;
        }

        public LicenseAssetGroup build() {
            return new LicenseAssetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseAssetGroup> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder licenseAssetGroupConfigurations(Collection<LicenseAssetGroupConfiguration> var1);

        public Builder licenseAssetGroupConfigurations(LicenseAssetGroupConfiguration ... var1);

        public Builder licenseAssetGroupConfigurations(Consumer<LicenseAssetGroupConfiguration.Builder> ... var1);

        public Builder associatedLicenseAssetRulesetARNs(Collection<String> var1);

        public Builder associatedLicenseAssetRulesetARNs(String ... var1);

        public Builder properties(Collection<LicenseAssetGroupProperty> var1);

        public Builder properties(LicenseAssetGroupProperty ... var1);

        public Builder properties(Consumer<LicenseAssetGroupProperty.Builder> ... var1);

        public Builder licenseAssetGroupArn(String var1);

        public Builder status(String var1);

        public Builder status(LicenseAssetGroupStatus var1);

        public Builder statusMessage(String var1);

        public Builder latestUsageAnalysisTime(Instant var1);

        public Builder latestResourceDiscoveryTime(Instant var1);
    }
}

