/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Asset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Asset> {
    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetArn").getter(Asset.getter(Asset::assetArn)).setter(Asset.setter(Builder::assetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetArn").build()}).build();
    private static final SdkField<Instant> LATEST_ASSET_DISCOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestAssetDiscoveryTime").getter(Asset.getter(Asset::latestAssetDiscoveryTime)).setter(Asset.setter(Builder::latestAssetDiscoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestAssetDiscoveryTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ARN_FIELD, LATEST_ASSET_DISCOVERY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Asset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetArn;
    private final Instant latestAssetDiscoveryTime;

    private Asset(BuilderImpl builder) {
        this.assetArn = builder.assetArn;
        this.latestAssetDiscoveryTime = builder.latestAssetDiscoveryTime;
    }

    public final String assetArn() {
        return this.assetArn;
    }

    public final Instant latestAssetDiscoveryTime() {
        return this.latestAssetDiscoveryTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAssetDiscoveryTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)obj;
        return Objects.equals(this.assetArn(), other.assetArn()) && Objects.equals(this.latestAssetDiscoveryTime(), other.latestAssetDiscoveryTime());
    }

    public final String toString() {
        return ToString.builder((String)"Asset").add("AssetArn", (Object)this.assetArn()).add("LatestAssetDiscoveryTime", (Object)this.latestAssetDiscoveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetArn": {
                return Optional.ofNullable(clazz.cast(this.assetArn()));
            }
            case "LatestAssetDiscoveryTime": {
                return Optional.ofNullable(clazz.cast(this.latestAssetDiscoveryTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssetArn", ASSET_ARN_FIELD);
        map.put("LatestAssetDiscoveryTime", LATEST_ASSET_DISCOVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Asset, T> g) {
        return obj -> g.apply((Asset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetArn;
        private Instant latestAssetDiscoveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Asset model) {
            this.assetArn(model.assetArn);
            this.latestAssetDiscoveryTime(model.latestAssetDiscoveryTime);
        }

        public final String getAssetArn() {
            return this.assetArn;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        @Override
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final Instant getLatestAssetDiscoveryTime() {
            return this.latestAssetDiscoveryTime;
        }

        public final void setLatestAssetDiscoveryTime(Instant latestAssetDiscoveryTime) {
            this.latestAssetDiscoveryTime = latestAssetDiscoveryTime;
        }

        @Override
        public final Builder latestAssetDiscoveryTime(Instant latestAssetDiscoveryTime) {
            this.latestAssetDiscoveryTime = latestAssetDiscoveryTime;
            return this;
        }

        public Asset build() {
            return new Asset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Asset> {
        public Builder assetArn(String var1);

        public Builder latestAssetDiscoveryTime(Instant var1);
    }
}

