/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.CheckoutType;
import software.amazon.awssdk.services.licensemanager.model.EntitlementData;
import software.amazon.awssdk.services.licensemanager.model.EntitlementDataListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckoutLicenseRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, CheckoutLicenseRequest> {
    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductSKU").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::productSKU)).setter(CheckoutLicenseRequest.setter(Builder::productSKU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()}).build();
    private static final SdkField<String> CHECKOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckoutType").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::checkoutTypeAsString)).setter(CheckoutLicenseRequest.setter(Builder::checkoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutType").build()}).build();
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFingerprint").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::keyFingerprint)).setter(CheckoutLicenseRequest.setter(Builder::keyFingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint").build()}).build();
    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::entitlements)).setter(CheckoutLicenseRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::clientToken)).setter(CheckoutLicenseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Beneficiary").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::beneficiary)).setter(CheckoutLicenseRequest.setter(Builder::beneficiary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(CheckoutLicenseRequest.getter(CheckoutLicenseRequest::nodeId)).setter(CheckoutLicenseRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_SKU_FIELD, CHECKOUT_TYPE_FIELD, KEY_FINGERPRINT_FIELD, ENTITLEMENTS_FIELD, CLIENT_TOKEN_FIELD, BENEFICIARY_FIELD, NODE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckoutLicenseRequest.memberNameToFieldInitializer();
    private final String productSKU;
    private final String checkoutType;
    private final String keyFingerprint;
    private final List<EntitlementData> entitlements;
    private final String clientToken;
    private final String beneficiary;
    private final String nodeId;

    private CheckoutLicenseRequest(BuilderImpl builder) {
        super(builder);
        this.productSKU = builder.productSKU;
        this.checkoutType = builder.checkoutType;
        this.keyFingerprint = builder.keyFingerprint;
        this.entitlements = builder.entitlements;
        this.clientToken = builder.clientToken;
        this.beneficiary = builder.beneficiary;
        this.nodeId = builder.nodeId;
    }

    public final String productSKU() {
        return this.productSKU;
    }

    public final CheckoutType checkoutType() {
        return CheckoutType.fromValue(this.checkoutType);
    }

    public final String checkoutTypeAsString() {
        return this.checkoutType;
    }

    public final String keyFingerprint() {
        return this.keyFingerprint;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<EntitlementData> entitlements() {
        return this.entitlements;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String beneficiary() {
        return this.beneficiary;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutLicenseRequest)) {
            return false;
        }
        CheckoutLicenseRequest other = (CheckoutLicenseRequest)((Object)obj);
        return Objects.equals(this.productSKU(), other.productSKU()) && Objects.equals(this.checkoutTypeAsString(), other.checkoutTypeAsString()) && Objects.equals(this.keyFingerprint(), other.keyFingerprint()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.beneficiary(), other.beneficiary()) && Objects.equals(this.nodeId(), other.nodeId());
    }

    public final String toString() {
        return ToString.builder((String)"CheckoutLicenseRequest").add("ProductSKU", (Object)this.productSKU()).add("CheckoutType", (Object)this.checkoutTypeAsString()).add("KeyFingerprint", (Object)this.keyFingerprint()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("ClientToken", (Object)this.clientToken()).add("Beneficiary", (Object)this.beneficiary()).add("NodeId", (Object)this.nodeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductSKU": {
                return Optional.ofNullable(clazz.cast(this.productSKU()));
            }
            case "CheckoutType": {
                return Optional.ofNullable(clazz.cast(this.checkoutTypeAsString()));
            }
            case "KeyFingerprint": {
                return Optional.ofNullable(clazz.cast(this.keyFingerprint()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Beneficiary": {
                return Optional.ofNullable(clazz.cast(this.beneficiary()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductSKU", PRODUCT_SKU_FIELD);
        map.put("CheckoutType", CHECKOUT_TYPE_FIELD);
        map.put("KeyFingerprint", KEY_FINGERPRINT_FIELD);
        map.put("Entitlements", ENTITLEMENTS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Beneficiary", BENEFICIARY_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckoutLicenseRequest, T> g) {
        return obj -> g.apply((CheckoutLicenseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String productSKU;
        private String checkoutType;
        private String keyFingerprint;
        private List<EntitlementData> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String beneficiary;
        private String nodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutLicenseRequest model) {
            super(model);
            this.productSKU(model.productSKU);
            this.checkoutType(model.checkoutType);
            this.keyFingerprint(model.keyFingerprint);
            this.entitlements(model.entitlements);
            this.clientToken(model.clientToken);
            this.beneficiary(model.beneficiary);
            this.nodeId(model.nodeId);
        }

        public final String getProductSKU() {
            return this.productSKU;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        @Override
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final String getCheckoutType() {
            return this.checkoutType;
        }

        public final void setCheckoutType(String checkoutType) {
            this.checkoutType = checkoutType;
        }

        @Override
        public final Builder checkoutType(String checkoutType) {
            this.checkoutType = checkoutType;
            return this;
        }

        @Override
        public final Builder checkoutType(CheckoutType checkoutType) {
            this.checkoutType(checkoutType == null ? null : checkoutType.toString());
            return this;
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlements() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<EntitlementData.BuilderImpl> entitlements) {
            this.entitlements = EntitlementDataListCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<EntitlementData> entitlements) {
            this.entitlements = EntitlementDataListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(EntitlementData ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<EntitlementData.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (EntitlementData)((EntitlementData.Builder)EntitlementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getBeneficiary() {
            return this.beneficiary;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckoutLicenseRequest build() {
            return new CheckoutLicenseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckoutLicenseRequest> {
        public Builder productSKU(String var1);

        public Builder checkoutType(String var1);

        public Builder checkoutType(CheckoutType var1);

        public Builder keyFingerprint(String var1);

        public Builder entitlements(Collection<EntitlementData> var1);

        public Builder entitlements(EntitlementData ... var1);

        public Builder entitlements(Consumer<EntitlementData.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder beneficiary(String var1);

        public Builder nodeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

