/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.GrantStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CreateGrantResponse> {
    private static final SdkField<String> GRANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantArn").getter(CreateGrantResponse.getter(CreateGrantResponse::grantArn)).setter(CreateGrantResponse.setter(Builder::grantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateGrantResponse.getter(CreateGrantResponse::statusAsString)).setter(CreateGrantResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(CreateGrantResponse.getter(CreateGrantResponse::version)).setter(CreateGrantResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_ARN_FIELD, STATUS_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGrantResponse.memberNameToFieldInitializer();
    private final String grantArn;
    private final String status;
    private final String version;

    private CreateGrantResponse(BuilderImpl builder) {
        super(builder);
        this.grantArn = builder.grantArn;
        this.status = builder.status;
        this.version = builder.version;
    }

    public final String grantArn() {
        return this.grantArn;
    }

    public final GrantStatus status() {
        return GrantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.grantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantResponse)) {
            return false;
        }
        CreateGrantResponse other = (CreateGrantResponse)((Object)obj);
        return Objects.equals(this.grantArn(), other.grantArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGrantResponse").add("GrantArn", (Object)this.grantArn()).add("Status", (Object)this.statusAsString()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantArn": {
                return Optional.ofNullable(clazz.cast(this.grantArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GrantArn", GRANT_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantResponse, T> g) {
        return obj -> g.apply((CreateGrantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String grantArn;
        private String status;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantResponse model) {
            super(model);
            this.grantArn(model.grantArn);
            this.status(model.status);
            this.version(model.version);
        }

        public final String getGrantArn() {
            return this.grantArn;
        }

        public final void setGrantArn(String grantArn) {
            this.grantArn = grantArn;
        }

        @Override
        public final Builder grantArn(String grantArn) {
            this.grantArn = grantArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public CreateGrantResponse build() {
            return new CreateGrantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantResponse> {
        public Builder grantArn(String var1);

        public Builder status(String var1);

        public Builder status(GrantStatus var1);

        public Builder version(String var1);
    }
}

