/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.CheckoutType;
import software.amazon.awssdk.services.licensemanager.model.EntitlementData;
import software.amazon.awssdk.services.licensemanager.model.EntitlementDataListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckoutLicenseResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CheckoutLicenseResponse> {
    private static final SdkField<String> CHECKOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckoutType").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::checkoutTypeAsString)).setter(CheckoutLicenseResponse.setter(Builder::checkoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutType").build()}).build();
    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConsumptionToken").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::licenseConsumptionToken)).setter(CheckoutLicenseResponse.setter(Builder::licenseConsumptionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build()}).build();
    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitlementsAllowed").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::entitlementsAllowed)).setter(CheckoutLicenseResponse.setter(Builder::entitlementsAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementsAllowed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SIGNED_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignedToken").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::signedToken)).setter(CheckoutLicenseResponse.setter(Builder::signedToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedToken").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::nodeId)).setter(CheckoutLicenseResponse.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuedAt").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::issuedAt)).setter(CheckoutLicenseResponse.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()}).build();
    private static final SdkField<String> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expiration").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::expiration)).setter(CheckoutLicenseResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CheckoutLicenseResponse.getter(CheckoutLicenseResponse::licenseArn)).setter(CheckoutLicenseResponse.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKOUT_TYPE_FIELD, LICENSE_CONSUMPTION_TOKEN_FIELD, ENTITLEMENTS_ALLOWED_FIELD, SIGNED_TOKEN_FIELD, NODE_ID_FIELD, ISSUED_AT_FIELD, EXPIRATION_FIELD, LICENSE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckoutLicenseResponse.memberNameToFieldInitializer();
    private final String checkoutType;
    private final String licenseConsumptionToken;
    private final List<EntitlementData> entitlementsAllowed;
    private final String signedToken;
    private final String nodeId;
    private final String issuedAt;
    private final String expiration;
    private final String licenseArn;

    private CheckoutLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.checkoutType = builder.checkoutType;
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.entitlementsAllowed = builder.entitlementsAllowed;
        this.signedToken = builder.signedToken;
        this.nodeId = builder.nodeId;
        this.issuedAt = builder.issuedAt;
        this.expiration = builder.expiration;
        this.licenseArn = builder.licenseArn;
    }

    public final CheckoutType checkoutType() {
        return CheckoutType.fromValue(this.checkoutType);
    }

    public final String checkoutTypeAsString() {
        return this.checkoutType;
    }

    public final String licenseConsumptionToken() {
        return this.licenseConsumptionToken;
    }

    public final boolean hasEntitlementsAllowed() {
        return this.entitlementsAllowed != null && !(this.entitlementsAllowed instanceof SdkAutoConstructList);
    }

    public final List<EntitlementData> entitlementsAllowed() {
        return this.entitlementsAllowed;
    }

    public final String signedToken() {
        return this.signedToken;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String issuedAt() {
        return this.issuedAt;
    }

    public final String expiration() {
        return this.expiration;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checkoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlementsAllowed() ? this.entitlementsAllowed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.signedToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutLicenseResponse)) {
            return false;
        }
        CheckoutLicenseResponse other = (CheckoutLicenseResponse)((Object)obj);
        return Objects.equals(this.checkoutTypeAsString(), other.checkoutTypeAsString()) && Objects.equals(this.licenseConsumptionToken(), other.licenseConsumptionToken()) && this.hasEntitlementsAllowed() == other.hasEntitlementsAllowed() && Objects.equals(this.entitlementsAllowed(), other.entitlementsAllowed()) && Objects.equals(this.signedToken(), other.signedToken()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.licenseArn(), other.licenseArn());
    }

    public final String toString() {
        return ToString.builder((String)"CheckoutLicenseResponse").add("CheckoutType", (Object)this.checkoutTypeAsString()).add("LicenseConsumptionToken", (Object)this.licenseConsumptionToken()).add("EntitlementsAllowed", this.hasEntitlementsAllowed() ? this.entitlementsAllowed() : null).add("SignedToken", (Object)this.signedToken()).add("NodeId", (Object)this.nodeId()).add("IssuedAt", (Object)this.issuedAt()).add("Expiration", (Object)this.expiration()).add("LicenseArn", (Object)this.licenseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckoutType": {
                return Optional.ofNullable(clazz.cast(this.checkoutTypeAsString()));
            }
            case "LicenseConsumptionToken": {
                return Optional.ofNullable(clazz.cast(this.licenseConsumptionToken()));
            }
            case "EntitlementsAllowed": {
                return Optional.ofNullable(clazz.cast(this.entitlementsAllowed()));
            }
            case "SignedToken": {
                return Optional.ofNullable(clazz.cast(this.signedToken()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CheckoutType", CHECKOUT_TYPE_FIELD);
        map.put("LicenseConsumptionToken", LICENSE_CONSUMPTION_TOKEN_FIELD);
        map.put("EntitlementsAllowed", ENTITLEMENTS_ALLOWED_FIELD);
        map.put("SignedToken", SIGNED_TOKEN_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckoutLicenseResponse, T> g) {
        return obj -> g.apply((CheckoutLicenseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String checkoutType;
        private String licenseConsumptionToken;
        private List<EntitlementData> entitlementsAllowed = DefaultSdkAutoConstructList.getInstance();
        private String signedToken;
        private String nodeId;
        private String issuedAt;
        private String expiration;
        private String licenseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutLicenseResponse model) {
            super(model);
            this.checkoutType(model.checkoutType);
            this.licenseConsumptionToken(model.licenseConsumptionToken);
            this.entitlementsAllowed(model.entitlementsAllowed);
            this.signedToken(model.signedToken);
            this.nodeId(model.nodeId);
            this.issuedAt(model.issuedAt);
            this.expiration(model.expiration);
            this.licenseArn(model.licenseArn);
        }

        public final String getCheckoutType() {
            return this.checkoutType;
        }

        public final void setCheckoutType(String checkoutType) {
            this.checkoutType = checkoutType;
        }

        @Override
        public final Builder checkoutType(String checkoutType) {
            this.checkoutType = checkoutType;
            return this;
        }

        @Override
        public final Builder checkoutType(CheckoutType checkoutType) {
            this.checkoutType(checkoutType == null ? null : checkoutType.toString());
            return this;
        }

        public final String getLicenseConsumptionToken() {
            return this.licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlementsAllowed() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlementsAllowed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlementsAllowed(Collection<EntitlementData.BuilderImpl> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copyFromBuilder(entitlementsAllowed);
        }

        @Override
        public final Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copy(entitlementsAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(EntitlementData ... entitlementsAllowed) {
            this.entitlementsAllowed(Arrays.asList(entitlementsAllowed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(Consumer<EntitlementData.Builder> ... entitlementsAllowed) {
            this.entitlementsAllowed(Stream.of(entitlementsAllowed).map(c -> (EntitlementData)((EntitlementData.Builder)EntitlementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSignedToken() {
            return this.signedToken;
        }

        public final void setSignedToken(String signedToken) {
            this.signedToken = signedToken;
        }

        @Override
        public final Builder signedToken(String signedToken) {
            this.signedToken = signedToken;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        @Override
        public CheckoutLicenseResponse build() {
            return new CheckoutLicenseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckoutLicenseResponse> {
        public Builder checkoutType(String var1);

        public Builder checkoutType(CheckoutType var1);

        public Builder licenseConsumptionToken(String var1);

        public Builder entitlementsAllowed(Collection<EntitlementData> var1);

        public Builder entitlementsAllowed(EntitlementData ... var1);

        public Builder entitlementsAllowed(Consumer<EntitlementData.Builder> ... var1);

        public Builder signedToken(String var1);

        public Builder nodeId(String var1);

        public Builder issuedAt(String var1);

        public Builder expiration(String var1);

        public Builder licenseArn(String var1);
    }
}

