/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration;
import software.amazon.awssdk.services.licensemanager.model.DatetimeRange;
import software.amazon.awssdk.services.licensemanager.model.Entitlement;
import software.amazon.awssdk.services.licensemanager.model.EntitlementListCopier;
import software.amazon.awssdk.services.licensemanager.model.IssuerDetails;
import software.amazon.awssdk.services.licensemanager.model.LicenseStatus;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantedLicense
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrantedLicense> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(GrantedLicense.getter(GrantedLicense::licenseArn)).setter(GrantedLicense.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseName").getter(GrantedLicense.getter(GrantedLicense::licenseName)).setter(GrantedLicense.setter(Builder::licenseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseName").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(GrantedLicense.getter(GrantedLicense::productName)).setter(GrantedLicense.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PRODUCT_SKU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductSKU").getter(GrantedLicense.getter(GrantedLicense::productSKU)).setter(GrantedLicense.setter(Builder::productSKU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSKU").build()}).build();
    private static final SdkField<IssuerDetails> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Issuer").getter(GrantedLicense.getter(GrantedLicense::issuer)).setter(GrantedLicense.setter(Builder::issuer)).constructor(IssuerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeRegion").getter(GrantedLicense.getter(GrantedLicense::homeRegion)).setter(GrantedLicense.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GrantedLicense.getter(GrantedLicense::statusAsString)).setter(GrantedLicense.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<DatetimeRange> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validity").getter(GrantedLicense.getter(GrantedLicense::validity)).setter(GrantedLicense.setter(Builder::validity)).constructor(DatetimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<String> BENEFICIARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Beneficiary").getter(GrantedLicense.getter(GrantedLicense::beneficiary)).setter(GrantedLicense.setter(Builder::beneficiary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beneficiary").build()}).build();
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(GrantedLicense.getter(GrantedLicense::entitlements)).setter(GrantedLicense.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entitlement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConsumptionConfiguration> CONSUMPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumptionConfiguration").getter(GrantedLicense.getter(GrantedLicense::consumptionConfiguration)).setter(GrantedLicense.setter(Builder::consumptionConfiguration)).constructor(ConsumptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumptionConfiguration").build()}).build();
    private static final SdkField<List<Metadata>> LICENSE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseMetadata").getter(GrantedLicense.getter(GrantedLicense::licenseMetadata)).setter(GrantedLicense.setter(Builder::licenseMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateTime").getter(GrantedLicense.getter(GrantedLicense::createTime)).setter(GrantedLicense.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GrantedLicense.getter(GrantedLicense::version)).setter(GrantedLicense.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<ReceivedMetadata> RECEIVED_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReceivedMetadata").getter(GrantedLicense.getter(GrantedLicense::receivedMetadata)).setter(GrantedLicense.setter(Builder::receivedMetadata)).constructor(ReceivedMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, LICENSE_NAME_FIELD, PRODUCT_NAME_FIELD, PRODUCT_SKU_FIELD, ISSUER_FIELD, HOME_REGION_FIELD, STATUS_FIELD, VALIDITY_FIELD, BENEFICIARY_FIELD, ENTITLEMENTS_FIELD, CONSUMPTION_CONFIGURATION_FIELD, LICENSE_METADATA_FIELD, CREATE_TIME_FIELD, VERSION_FIELD, RECEIVED_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GrantedLicense.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String licenseArn;
    private final String licenseName;
    private final String productName;
    private final String productSKU;
    private final IssuerDetails issuer;
    private final String homeRegion;
    private final String status;
    private final DatetimeRange validity;
    private final String beneficiary;
    private final List<Entitlement> entitlements;
    private final ConsumptionConfiguration consumptionConfiguration;
    private final List<Metadata> licenseMetadata;
    private final String createTime;
    private final String version;
    private final ReceivedMetadata receivedMetadata;

    private GrantedLicense(BuilderImpl builder) {
        this.licenseArn = builder.licenseArn;
        this.licenseName = builder.licenseName;
        this.productName = builder.productName;
        this.productSKU = builder.productSKU;
        this.issuer = builder.issuer;
        this.homeRegion = builder.homeRegion;
        this.status = builder.status;
        this.validity = builder.validity;
        this.beneficiary = builder.beneficiary;
        this.entitlements = builder.entitlements;
        this.consumptionConfiguration = builder.consumptionConfiguration;
        this.licenseMetadata = builder.licenseMetadata;
        this.createTime = builder.createTime;
        this.version = builder.version;
        this.receivedMetadata = builder.receivedMetadata;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String licenseName() {
        return this.licenseName;
    }

    public final String productName() {
        return this.productName;
    }

    public final String productSKU() {
        return this.productSKU;
    }

    public final IssuerDetails issuer() {
        return this.issuer;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final LicenseStatus status() {
        return LicenseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DatetimeRange validity() {
        return this.validity;
    }

    public final String beneficiary() {
        return this.beneficiary;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<Entitlement> entitlements() {
        return this.entitlements;
    }

    public final ConsumptionConfiguration consumptionConfiguration() {
        return this.consumptionConfiguration;
    }

    public final boolean hasLicenseMetadata() {
        return this.licenseMetadata != null && !(this.licenseMetadata instanceof SdkAutoConstructList);
    }

    public final List<Metadata> licenseMetadata() {
        return this.licenseMetadata;
    }

    public final String createTime() {
        return this.createTime;
    }

    public final String version() {
        return this.version;
    }

    public final ReceivedMetadata receivedMetadata() {
        return this.receivedMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.productSKU());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.beneficiary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consumptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseMetadata() ? this.licenseMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantedLicense)) {
            return false;
        }
        GrantedLicense other = (GrantedLicense)obj;
        return Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.licenseName(), other.licenseName()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.productSKU(), other.productSKU()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.beneficiary(), other.beneficiary()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.consumptionConfiguration(), other.consumptionConfiguration()) && this.hasLicenseMetadata() == other.hasLicenseMetadata() && Objects.equals(this.licenseMetadata(), other.licenseMetadata()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.receivedMetadata(), other.receivedMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GrantedLicense").add("LicenseArn", (Object)this.licenseArn()).add("LicenseName", (Object)this.licenseName()).add("ProductName", (Object)this.productName()).add("ProductSKU", (Object)this.productSKU()).add("Issuer", (Object)this.issuer()).add("HomeRegion", (Object)this.homeRegion()).add("Status", (Object)this.statusAsString()).add("Validity", (Object)this.validity()).add("Beneficiary", (Object)this.beneficiary()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("ConsumptionConfiguration", (Object)this.consumptionConfiguration()).add("LicenseMetadata", this.hasLicenseMetadata() ? this.licenseMetadata() : null).add("CreateTime", (Object)this.createTime()).add("Version", (Object)this.version()).add("ReceivedMetadata", (Object)this.receivedMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "LicenseName": {
                return Optional.ofNullable(clazz.cast(this.licenseName()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProductSKU": {
                return Optional.ofNullable(clazz.cast(this.productSKU()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "HomeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "Beneficiary": {
                return Optional.ofNullable(clazz.cast(this.beneficiary()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "ConsumptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.consumptionConfiguration()));
            }
            case "LicenseMetadata": {
                return Optional.ofNullable(clazz.cast(this.licenseMetadata()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "ReceivedMetadata": {
                return Optional.ofNullable(clazz.cast(this.receivedMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        map.put("LicenseName", LICENSE_NAME_FIELD);
        map.put("ProductName", PRODUCT_NAME_FIELD);
        map.put("ProductSKU", PRODUCT_SKU_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Validity", VALIDITY_FIELD);
        map.put("Beneficiary", BENEFICIARY_FIELD);
        map.put("Entitlements", ENTITLEMENTS_FIELD);
        map.put("ConsumptionConfiguration", CONSUMPTION_CONFIGURATION_FIELD);
        map.put("LicenseMetadata", LICENSE_METADATA_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("ReceivedMetadata", RECEIVED_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrantedLicense, T> g) {
        return obj -> g.apply((GrantedLicense)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String licenseArn;
        private String licenseName;
        private String productName;
        private String productSKU;
        private IssuerDetails issuer;
        private String homeRegion;
        private String status;
        private DatetimeRange validity;
        private String beneficiary;
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();
        private ConsumptionConfiguration consumptionConfiguration;
        private List<Metadata> licenseMetadata = DefaultSdkAutoConstructList.getInstance();
        private String createTime;
        private String version;
        private ReceivedMetadata receivedMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantedLicense model) {
            this.licenseArn(model.licenseArn);
            this.licenseName(model.licenseName);
            this.productName(model.productName);
            this.productSKU(model.productSKU);
            this.issuer(model.issuer);
            this.homeRegion(model.homeRegion);
            this.status(model.status);
            this.validity(model.validity);
            this.beneficiary(model.beneficiary);
            this.entitlements(model.entitlements);
            this.consumptionConfiguration(model.consumptionConfiguration);
            this.licenseMetadata(model.licenseMetadata);
            this.createTime(model.createTime);
            this.version(model.version);
            this.receivedMetadata(model.receivedMetadata);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseName() {
            return this.licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProductSKU() {
            return this.productSKU;
        }

        public final void setProductSKU(String productSKU) {
            this.productSKU = productSKU;
        }

        @Override
        public final Builder productSKU(String productSKU) {
            this.productSKU = productSKU;
            return this;
        }

        public final IssuerDetails.Builder getIssuer() {
            return this.issuer != null ? this.issuer.toBuilder() : null;
        }

        public final void setIssuer(IssuerDetails.BuilderImpl issuer) {
            this.issuer = issuer != null ? issuer.build() : null;
        }

        @Override
        public final Builder issuer(IssuerDetails issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DatetimeRange.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        public final void setValidity(DatetimeRange.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        public final Builder validity(DatetimeRange validity) {
            this.validity = validity;
            return this;
        }

        public final String getBeneficiary() {
            return this.beneficiary;
        }

        public final void setBeneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
        }

        @Override
        public final Builder beneficiary(String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = EntitlementListCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = EntitlementListCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = EntitlementListCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (Entitlement)((Entitlement.Builder)Entitlement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConsumptionConfiguration.Builder getConsumptionConfiguration() {
            return this.consumptionConfiguration != null ? this.consumptionConfiguration.toBuilder() : null;
        }

        public final void setConsumptionConfiguration(ConsumptionConfiguration.BuilderImpl consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration != null ? consumptionConfiguration.build() : null;
        }

        @Override
        public final Builder consumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        public final List<Metadata.Builder> getLicenseMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.licenseMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseMetadata(Collection<Metadata.BuilderImpl> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copyFromBuilder(licenseMetadata);
        }

        @Override
        public final Builder licenseMetadata(Collection<Metadata> licenseMetadata) {
            this.licenseMetadata = MetadataListCopier.copy(licenseMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Metadata ... licenseMetadata) {
            this.licenseMetadata(Arrays.asList(licenseMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseMetadata(Consumer<Metadata.Builder> ... licenseMetadata) {
            this.licenseMetadata(Stream.of(licenseMetadata).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final ReceivedMetadata.Builder getReceivedMetadata() {
            return this.receivedMetadata != null ? this.receivedMetadata.toBuilder() : null;
        }

        public final void setReceivedMetadata(ReceivedMetadata.BuilderImpl receivedMetadata) {
            this.receivedMetadata = receivedMetadata != null ? receivedMetadata.build() : null;
        }

        @Override
        public final Builder receivedMetadata(ReceivedMetadata receivedMetadata) {
            this.receivedMetadata = receivedMetadata;
            return this;
        }

        public GrantedLicense build() {
            return new GrantedLicense(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrantedLicense> {
        public Builder licenseArn(String var1);

        public Builder licenseName(String var1);

        public Builder productName(String var1);

        public Builder productSKU(String var1);

        public Builder issuer(IssuerDetails var1);

        default public Builder issuer(Consumer<IssuerDetails.Builder> issuer) {
            return this.issuer((IssuerDetails)((IssuerDetails.Builder)IssuerDetails.builder().applyMutation(issuer)).build());
        }

        public Builder homeRegion(String var1);

        public Builder status(String var1);

        public Builder status(LicenseStatus var1);

        public Builder validity(DatetimeRange var1);

        default public Builder validity(Consumer<DatetimeRange.Builder> validity) {
            return this.validity((DatetimeRange)((DatetimeRange.Builder)DatetimeRange.builder().applyMutation(validity)).build());
        }

        public Builder beneficiary(String var1);

        public Builder entitlements(Collection<Entitlement> var1);

        public Builder entitlements(Entitlement ... var1);

        public Builder entitlements(Consumer<Entitlement.Builder> ... var1);

        public Builder consumptionConfiguration(ConsumptionConfiguration var1);

        default public Builder consumptionConfiguration(Consumer<ConsumptionConfiguration.Builder> consumptionConfiguration) {
            return this.consumptionConfiguration((ConsumptionConfiguration)((ConsumptionConfiguration.Builder)ConsumptionConfiguration.builder().applyMutation(consumptionConfiguration)).build());
        }

        public Builder licenseMetadata(Collection<Metadata> var1);

        public Builder licenseMetadata(Metadata ... var1);

        public Builder licenseMetadata(Consumer<Metadata.Builder> ... var1);

        public Builder createTime(String var1);

        public Builder version(String var1);

        public Builder receivedMetadata(ReceivedMetadata var1);

        default public Builder receivedMetadata(Consumer<ReceivedMetadata.Builder> receivedMetadata) {
            return this.receivedMetadata((ReceivedMetadata)((ReceivedMetadata.Builder)ReceivedMetadata.builder().applyMutation(receivedMetadata)).build());
        }
    }
}

