/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.licensemanager.DefaultLicenseManagerBaseClientBuilder;
import software.amazon.awssdk.services.licensemanager.DefaultLicenseManagerClient;
import software.amazon.awssdk.services.licensemanager.LicenseManagerClient;
import software.amazon.awssdk.services.licensemanager.LicenseManagerClientBuilder;
import software.amazon.awssdk.services.licensemanager.LicenseManagerServiceClientConfiguration;
import software.amazon.awssdk.services.licensemanager.endpoints.LicenseManagerEndpointProvider;

@SdkInternalApi
final class DefaultLicenseManagerClientBuilder
extends DefaultLicenseManagerBaseClientBuilder<LicenseManagerClientBuilder, LicenseManagerClient>
implements LicenseManagerClientBuilder {
    DefaultLicenseManagerClientBuilder() {
    }

    @Override
    public DefaultLicenseManagerClientBuilder endpointProvider(LicenseManagerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LicenseManagerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLicenseManagerClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        LicenseManagerServiceClientConfiguration serviceClientConfiguration = LicenseManagerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultLicenseManagerClient(serviceClientConfiguration, clientConfiguration);
    }
}

