/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RenewType {
    NONE("None"),
    WEEKLY("Weekly"),
    MONTHLY("Monthly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RenewType> VALUE_MAP;
    private final String value;

    private RenewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RenewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RenewType> knownValues() {
        EnumSet<RenewType> knownValues = EnumSet.allOf(RenewType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RenewType.class, RenewType::toString);
    }
}

