/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.EntitlementUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entitlement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entitlement> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Entitlement.getter(Entitlement::name)).setter(Entitlement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Entitlement.getter(Entitlement::value)).setter(Entitlement.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Long> MAX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxCount").getter(Entitlement.getter(Entitlement::maxCount)).setter(Entitlement.setter(Builder::maxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").build()}).build();
    private static final SdkField<Boolean> OVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Overage").getter(Entitlement.getter(Entitlement::overage)).setter(Entitlement.setter(Builder::overage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overage").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Entitlement.getter(Entitlement::unitAsString)).setter(Entitlement.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Boolean> ALLOW_CHECK_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCheckIn").getter(Entitlement.getter(Entitlement::allowCheckIn)).setter(Entitlement.setter(Builder::allowCheckIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCheckIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD, MAX_COUNT_FIELD, OVERAGE_FIELD, UNIT_FIELD, ALLOW_CHECK_IN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;
    private final Long maxCount;
    private final Boolean overage;
    private final String unit;
    private final Boolean allowCheckIn;

    private Entitlement(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.maxCount = builder.maxCount;
        this.overage = builder.overage;
        this.unit = builder.unit;
        this.allowCheckIn = builder.allowCheckIn;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final Long maxCount() {
        return this.maxCount;
    }

    public final Boolean overage() {
        return this.overage;
    }

    public final EntitlementUnit unit() {
        return EntitlementUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Boolean allowCheckIn() {
        return this.allowCheckIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.overage());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCheckIn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.maxCount(), other.maxCount()) && Objects.equals(this.overage(), other.overage()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.allowCheckIn(), other.allowCheckIn());
    }

    public final String toString() {
        return ToString.builder((String)"Entitlement").add("Name", (Object)this.name()).add("Value", (Object)this.value()).add("MaxCount", (Object)this.maxCount()).add("Overage", (Object)this.overage()).add("Unit", (Object)this.unitAsString()).add("AllowCheckIn", (Object)this.allowCheckIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "MaxCount": {
                return Optional.ofNullable(clazz.cast(this.maxCount()));
            }
            case "Overage": {
                return Optional.ofNullable(clazz.cast(this.overage()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "AllowCheckIn": {
                return Optional.ofNullable(clazz.cast(this.allowCheckIn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private Long maxCount;
        private Boolean overage;
        private String unit;
        private Boolean allowCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            this.name(model.name);
            this.value(model.value);
            this.maxCount(model.maxCount);
            this.overage(model.overage);
            this.unit(model.unit);
            this.allowCheckIn(model.allowCheckIn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Long getMaxCount() {
            return this.maxCount;
        }

        public final void setMaxCount(Long maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        @Transient
        public final Builder maxCount(Long maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Boolean getOverage() {
            return this.overage;
        }

        public final void setOverage(Boolean overage) {
            this.overage = overage;
        }

        @Override
        @Transient
        public final Builder overage(Boolean overage) {
            this.overage = overage;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(EntitlementUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Boolean getAllowCheckIn() {
            return this.allowCheckIn;
        }

        public final void setAllowCheckIn(Boolean allowCheckIn) {
            this.allowCheckIn = allowCheckIn;
        }

        @Override
        @Transient
        public final Builder allowCheckIn(Boolean allowCheckIn) {
            this.allowCheckIn = allowCheckIn;
            return this;
        }

        public Entitlement build() {
            return new Entitlement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entitlement> {
        public Builder name(String var1);

        public Builder value(String var1);

        public Builder maxCount(Long var1);

        public Builder overage(Boolean var1);

        public Builder unit(String var1);

        public Builder unit(EntitlementUnit var1);

        public Builder allowCheckIn(Boolean var1);
    }
}

