/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailure;
import software.amazon.awssdk.services.licensemanager.model.LicenseOperationFailureListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFailuresForLicenseConfigurationOperationsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListFailuresForLicenseConfigurationOperationsResponse> {
    private static final SdkField<List<LicenseOperationFailure>> LICENSE_OPERATION_FAILURE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseOperationFailureList").getter(ListFailuresForLicenseConfigurationOperationsResponse.getter(ListFailuresForLicenseConfigurationOperationsResponse::licenseOperationFailureList)).setter(ListFailuresForLicenseConfigurationOperationsResponse.setter(Builder::licenseOperationFailureList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseOperationFailureList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseOperationFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFailuresForLicenseConfigurationOperationsResponse.getter(ListFailuresForLicenseConfigurationOperationsResponse::nextToken)).setter(ListFailuresForLicenseConfigurationOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_OPERATION_FAILURE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<LicenseOperationFailure> licenseOperationFailureList;
    private final String nextToken;

    private ListFailuresForLicenseConfigurationOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseOperationFailureList = builder.licenseOperationFailureList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLicenseOperationFailureList() {
        return this.licenseOperationFailureList != null && !(this.licenseOperationFailureList instanceof SdkAutoConstructList);
    }

    public List<LicenseOperationFailure> licenseOperationFailureList() {
        return this.licenseOperationFailureList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseOperationFailureList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFailuresForLicenseConfigurationOperationsResponse)) {
            return false;
        }
        ListFailuresForLicenseConfigurationOperationsResponse other = (ListFailuresForLicenseConfigurationOperationsResponse)((Object)obj);
        return Objects.equals(this.licenseOperationFailureList(), other.licenseOperationFailureList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFailuresForLicenseConfigurationOperationsResponse").add("LicenseOperationFailureList", this.licenseOperationFailureList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseOperationFailureList": {
                return Optional.ofNullable(clazz.cast(this.licenseOperationFailureList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFailuresForLicenseConfigurationOperationsResponse, T> g) {
        return obj -> g.apply((ListFailuresForLicenseConfigurationOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseOperationFailure> licenseOperationFailureList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFailuresForLicenseConfigurationOperationsResponse model) {
            super(model);
            this.licenseOperationFailureList(model.licenseOperationFailureList);
            this.nextToken(model.nextToken);
        }

        public final Collection<LicenseOperationFailure.Builder> getLicenseOperationFailureList() {
            return this.licenseOperationFailureList != null ? (Collection)this.licenseOperationFailureList.stream().map(LicenseOperationFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseOperationFailureList(Collection<LicenseOperationFailure> licenseOperationFailureList) {
            this.licenseOperationFailureList = LicenseOperationFailureListCopier.copy(licenseOperationFailureList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseOperationFailureList(LicenseOperationFailure ... licenseOperationFailureList) {
            this.licenseOperationFailureList(Arrays.asList(licenseOperationFailureList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseOperationFailureList(Consumer<LicenseOperationFailure.Builder> ... licenseOperationFailureList) {
            this.licenseOperationFailureList(Stream.of(licenseOperationFailureList).map(c -> (LicenseOperationFailure)((LicenseOperationFailure.Builder)LicenseOperationFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseOperationFailureList(Collection<LicenseOperationFailure.BuilderImpl> licenseOperationFailureList) {
            this.licenseOperationFailureList = LicenseOperationFailureListCopier.copyFromBuilder(licenseOperationFailureList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFailuresForLicenseConfigurationOperationsResponse build() {
            return new ListFailuresForLicenseConfigurationOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFailuresForLicenseConfigurationOperationsResponse> {
        public Builder licenseOperationFailureList(Collection<LicenseOperationFailure> var1);

        public Builder licenseOperationFailureList(LicenseOperationFailure ... var1);

        public Builder licenseOperationFailureList(Consumer<LicenseOperationFailure.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

