/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.ImageResponseCard;
import software.amazon.awssdk.services.lexruntimev2.model.MessageContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(Message.getter(Message::content)).setter(Message.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(Message.getter(Message::contentTypeAsString)).setter(Message.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<ImageResponseCard> IMAGE_RESPONSE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageResponseCard").getter(Message.getter(Message::imageResponseCard)).setter(Message.setter(Builder::imageResponseCard)).constructor(ImageResponseCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageResponseCard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, CONTENT_TYPE_FIELD, IMAGE_RESPONSE_CARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Message.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String contentType;
    private final ImageResponseCard imageResponseCard;

    private Message(BuilderImpl builder) {
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.imageResponseCard = builder.imageResponseCard;
    }

    public final String content() {
        return this.content;
    }

    public final MessageContentType contentType() {
        return MessageContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final ImageResponseCard imageResponseCard() {
        return this.imageResponseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageResponseCard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.imageResponseCard(), other.imageResponseCard());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentTypeAsString()).add("ImageResponseCard", (Object)this.imageResponseCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "imageResponseCard": {
                return Optional.ofNullable(clazz.cast(this.imageResponseCard()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("imageResponseCard", IMAGE_RESPONSE_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String contentType;
        private ImageResponseCard imageResponseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.content(model.content);
            this.contentType(model.contentType);
            this.imageResponseCard(model.imageResponseCard);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(MessageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ImageResponseCard.Builder getImageResponseCard() {
            return this.imageResponseCard != null ? this.imageResponseCard.toBuilder() : null;
        }

        public final void setImageResponseCard(ImageResponseCard.BuilderImpl imageResponseCard) {
            this.imageResponseCard = imageResponseCard != null ? imageResponseCard.build() : null;
        }

        @Override
        public final Builder imageResponseCard(ImageResponseCard imageResponseCard) {
            this.imageResponseCard = imageResponseCard;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder content(String var1);

        public Builder contentType(String var1);

        public Builder contentType(MessageContentType var1);

        public Builder imageResponseCard(ImageResponseCard var1);

        default public Builder imageResponseCard(Consumer<ImageResponseCard.Builder> imageResponseCard) {
            return this.imageResponseCard((ImageResponseCard)((ImageResponseCard.Builder)ImageResponseCard.builder().applyMutation(imageResponseCard)).build());
        }
    }
}

