/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IntentState {
    FAILED("Failed"),
    FULFILLED("Fulfilled"),
    IN_PROGRESS("InProgress"),
    READY_FOR_FULFILLMENT("ReadyForFulfillment"),
    WAITING("Waiting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IntentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IntentState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntentState> knownValues() {
        return Stream.of(IntentState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

