/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexruntimev2.model.Interpretation;
import software.amazon.awssdk.services.lexruntimev2.model.InterpretationsCopier;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Response;
import software.amazon.awssdk.services.lexruntimev2.model.Message;
import software.amazon.awssdk.services.lexruntimev2.model.MessagesCopier;
import software.amazon.awssdk.services.lexruntimev2.model.SessionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponse
extends LexRuntimeV2Response
implements ToCopyableBuilder<Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionResponse.getter(GetSessionResponse::sessionId)).setter(GetSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(GetSessionResponse.getter(GetSessionResponse::messages)).setter(GetSessionResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Interpretation>> INTERPRETATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("interpretations").getter(GetSessionResponse.getter(GetSessionResponse::interpretations)).setter(GetSessionResponse.setter(Builder::interpretations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Interpretation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(GetSessionResponse.getter(GetSessionResponse::sessionState)).setter(GetSessionResponse.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, MESSAGES_FIELD, INTERPRETATIONS_FIELD, SESSION_STATE_FIELD));
    private final String sessionId;
    private final List<Message> messages;
    private final List<Interpretation> interpretations;
    private final SessionState sessionState;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.messages = builder.messages;
        this.interpretations = builder.interpretations;
        this.sessionState = builder.sessionState;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final boolean hasInterpretations() {
        return this.interpretations != null && !(this.interpretations instanceof SdkAutoConstructList);
    }

    public final List<Interpretation> interpretations() {
        return this.interpretations;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterpretations() ? this.interpretations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasInterpretations() == other.hasInterpretations() && Objects.equals(this.interpretations(), other.interpretations()) && Objects.equals(this.sessionState(), other.sessionState());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionResponse").add("SessionId", (Object)this.sessionId()).add("Messages", this.hasMessages() ? this.messages() : null).add("Interpretations", this.hasInterpretations() ? this.interpretations() : null).add("SessionState", (Object)this.sessionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "interpretations": {
                return Optional.ofNullable(clazz.cast(this.interpretations()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Response.BuilderImpl
    implements Builder {
        private String sessionId;
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private List<Interpretation> interpretations = DefaultSdkAutoConstructList.getInstance();
        private SessionState sessionState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.messages(model.messages);
            this.interpretations(model.interpretations);
            this.sessionState(model.sessionState);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final Collection<Message.Builder> getMessages() {
            if (this.messages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messages != null ? (Collection)this.messages.stream().map(Message::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        public final Collection<Interpretation.Builder> getInterpretations() {
            if (this.interpretations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.interpretations != null ? (Collection)this.interpretations.stream().map(Interpretation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder interpretations(Collection<Interpretation> interpretations) {
            this.interpretations = InterpretationsCopier.copy(interpretations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Interpretation ... interpretations) {
            this.interpretations(Arrays.asList(interpretations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interpretations(Consumer<Interpretation.Builder> ... interpretations) {
            this.interpretations(Stream.of(interpretations).map(c -> (Interpretation)((Interpretation.Builder)Interpretation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInterpretations(Collection<Interpretation.BuilderImpl> interpretations) {
            this.interpretations = InterpretationsCopier.copyFromBuilder(interpretations);
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionResponse> {
        public Builder sessionId(String var1);

        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder interpretations(Collection<Interpretation> var1);

        public Builder interpretations(Interpretation ... var1);

        public Builder interpretations(Consumer<Interpretation.Builder> ... var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }
    }
}

