/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntime.model.ActiveContextParametersMapCopier;
import software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveContext> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ActiveContext.getter(ActiveContext::name)).setter(ActiveContext.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ActiveContextTimeToLive> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeToLive").getter(ActiveContext.getter(ActiveContext::timeToLive)).setter(ActiveContext.setter(Builder::timeToLive)).constructor(ActiveContextTimeToLive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLive").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(ActiveContext.getter(ActiveContext::parameters)).setter(ActiveContext.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TIME_TO_LIVE_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("timeToLive", TIME_TO_LIVE_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ActiveContextTimeToLive timeToLive;
    private final Map<String, String> parameters;

    private ActiveContext(BuilderImpl builder) {
        this.name = builder.name;
        this.timeToLive = builder.timeToLive;
        this.parameters = builder.parameters;
    }

    public final String name() {
        return this.name;
    }

    public final ActiveContextTimeToLive timeToLive() {
        return this.timeToLive;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveContext)) {
            return false;
        }
        ActiveContext other = (ActiveContext)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.timeToLive(), other.timeToLive()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveContext").add("Name", (Object)this.name()).add("TimeToLive", (Object)this.timeToLive()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "timeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActiveContext, T> g) {
        return obj -> g.apply((ActiveContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ActiveContextTimeToLive timeToLive;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveContext model) {
            this.name(model.name);
            this.timeToLive(model.timeToLive);
            this.parameters(model.parameters);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ActiveContextTimeToLive.Builder getTimeToLive() {
            return this.timeToLive != null ? this.timeToLive.toBuilder() : null;
        }

        public final void setTimeToLive(ActiveContextTimeToLive.BuilderImpl timeToLive) {
            this.timeToLive = timeToLive != null ? timeToLive.build() : null;
        }

        @Override
        public final Builder timeToLive(ActiveContextTimeToLive timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ActiveContextParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ActiveContextParametersMapCopier.copy(parameters);
            return this;
        }

        public ActiveContext build() {
            return new ActiveContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveContext> {
        public Builder name(String var1);

        public Builder timeToLive(ActiveContextTimeToLive var1);

        default public Builder timeToLive(Consumer<ActiveContextTimeToLive.Builder> timeToLive) {
            return this.timeToLive((ActiveContextTimeToLive)((ActiveContextTimeToLive.Builder)ActiveContextTimeToLive.builder().applyMutation(timeToLive)).build());
        }

        public Builder parameters(Map<String, String> var1);
    }
}

