/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntime.model.LexRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSessionResponse
extends LexRuntimeResponse
implements ToCopyableBuilder<Builder, DeleteSessionResponse> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(DeleteSessionResponse.getter(DeleteSessionResponse::botName)).setter(DeleteSessionResponse.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAlias").getter(DeleteSessionResponse.getter(DeleteSessionResponse::botAlias)).setter(DeleteSessionResponse.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAlias").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(DeleteSessionResponse.getter(DeleteSessionResponse::userId)).setter(DeleteSessionResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(DeleteSessionResponse.getter(DeleteSessionResponse::sessionId)).setter(DeleteSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD, BOT_ALIAS_FIELD, USER_ID_FIELD, SESSION_ID_FIELD));
    private final String botName;
    private final String botAlias;
    private final String userId;
    private final String sessionId;

    private DeleteSessionResponse(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botAlias = builder.botAlias;
        this.userId = builder.userId;
        this.sessionId = builder.sessionId;
    }

    public final String botName() {
        return this.botName;
    }

    public final String botAlias() {
        return this.botAlias;
    }

    public final String userId() {
        return this.userId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSessionResponse)) {
            return false;
        }
        DeleteSessionResponse other = (DeleteSessionResponse)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSessionResponse").add("BotName", (Object)this.botName()).add("BotAlias", (Object)this.botAlias()).add("UserId", (Object)this.userId()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSessionResponse, T> g) {
        return obj -> g.apply((DeleteSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeResponse.BuilderImpl
    implements Builder {
        private String botName;
        private String botAlias;
        private String userId;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSessionResponse model) {
            super(model);
            this.botName(model.botName);
            this.botAlias(model.botAlias);
            this.userId(model.userId);
            this.sessionId(model.sessionId);
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        @Transient
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        @Override
        @Transient
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public DeleteSessionResponse build() {
            return new DeleteSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSessionResponse> {
        public Builder botName(String var1);

        public Builder botAlias(String var1);

        public Builder userId(String var1);

        public Builder sessionId(String var1);
    }
}

