/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListImportsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListImportsResponse.getter(ListImportsResponse::botId)).setter(ListImportsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListImportsResponse.getter(ListImportsResponse::botVersion)).setter(ListImportsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<List<ImportSummary>> IMPORT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importSummaries").getter(ListImportsResponse.getter(ListImportsResponse::importSummaries)).setter(ListImportsResponse.setter(Builder::importSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImportsResponse.getter(ListImportsResponse::nextToken)).setter(ListImportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListImportsResponse.getter(ListImportsResponse::localeId)).setter(ListImportsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, IMPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImportsResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final List<ImportSummary> importSummaries;
    private final String nextToken;
    private final String localeId;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.importSummaries = builder.importSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final boolean hasImportSummaries() {
        return this.importSummaries != null && !(this.importSummaries instanceof SdkAutoConstructList);
    }

    public final List<ImportSummary> importSummaries() {
        return this.importSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String localeId() {
        return this.localeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportSummaries() ? this.importSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && this.hasImportSummaries() == other.hasImportSummaries() && Objects.equals(this.importSummaries(), other.importSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.localeId(), other.localeId());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("ImportSummaries", this.hasImportSummaries() ? this.importSummaries() : null).add("NextToken", (Object)this.nextToken()).add("LocaleId", (Object)this.localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "importSummaries": {
                return Optional.ofNullable(clazz.cast(this.importSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("importSummaries", IMPORT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsResponse, T> g) {
        return obj -> g.apply((ListImportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private List<ImportSummary> importSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.importSummaries(model.importSummaries);
            this.nextToken(model.nextToken);
            this.localeId(model.localeId);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final List<ImportSummary.Builder> getImportSummaries() {
            List<ImportSummary.Builder> result = ImportSummaryListCopier.copyToBuilder(this.importSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportSummaries(Collection<ImportSummary.BuilderImpl> importSummaries) {
            this.importSummaries = ImportSummaryListCopier.copyFromBuilder(importSummaries);
        }

        @Override
        public final Builder importSummaries(Collection<ImportSummary> importSummaries) {
            this.importSummaries = ImportSummaryListCopier.copy(importSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaries(ImportSummary ... importSummaries) {
            this.importSummaries(Arrays.asList(importSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaries(Consumer<ImportSummary.Builder> ... importSummaries) {
            this.importSummaries(Stream.of(importSummaries).map(c -> (ImportSummary)((ImportSummary.Builder)ImportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImportsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder importSummaries(Collection<ImportSummary> var1);

        public Builder importSummaries(ImportSummary ... var1);

        public Builder importSummaries(Consumer<ImportSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder localeId(String var1);
    }
}

