/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBotResourceGenerationResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, StartBotResourceGenerationResponse> {
    private static final SdkField<String> GENERATION_INPUT_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationInputPrompt").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::generationInputPrompt)).setter(StartBotResourceGenerationResponse.setter(Builder::generationInputPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationInputPrompt").build()}).build();
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationId").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::generationId)).setter(StartBotResourceGenerationResponse.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::botId)).setter(StartBotResourceGenerationResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::botVersion)).setter(StartBotResourceGenerationResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::localeId)).setter(StartBotResourceGenerationResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationStatus").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::generationStatusAsString)).setter(StartBotResourceGenerationResponse.setter(Builder::generationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(StartBotResourceGenerationResponse.getter(StartBotResourceGenerationResponse::creationDateTime)).setter(StartBotResourceGenerationResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_INPUT_PROMPT_FIELD, GENERATION_ID_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, GENERATION_STATUS_FIELD, CREATION_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("generationInputPrompt", GENERATION_INPUT_PROMPT_FIELD);
            this.put("generationId", GENERATION_ID_FIELD);
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("generationStatus", GENERATION_STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        }
    });
    private final String generationInputPrompt;
    private final String generationId;
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String generationStatus;
    private final Instant creationDateTime;

    private StartBotResourceGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.generationInputPrompt = builder.generationInputPrompt;
        this.generationId = builder.generationId;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.generationStatus = builder.generationStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    public final String generationInputPrompt() {
        return this.generationInputPrompt;
    }

    public final String generationId() {
        return this.generationId;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(this.generationStatus);
    }

    public final String generationStatusAsString() {
        return this.generationStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.generationInputPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBotResourceGenerationResponse)) {
            return false;
        }
        StartBotResourceGenerationResponse other = (StartBotResourceGenerationResponse)((Object)obj);
        return Objects.equals(this.generationInputPrompt(), other.generationInputPrompt()) && Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.generationStatusAsString(), other.generationStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartBotResourceGenerationResponse").add("GenerationInputPrompt", (Object)this.generationInputPrompt()).add("GenerationId", (Object)this.generationId()).add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("GenerationStatus", (Object)this.generationStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "generationInputPrompt": {
                return Optional.ofNullable(clazz.cast(this.generationInputPrompt()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "generationStatus": {
                return Optional.ofNullable(clazz.cast(this.generationStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartBotResourceGenerationResponse, T> g) {
        return obj -> g.apply((StartBotResourceGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String generationInputPrompt;
        private String generationId;
        private String botId;
        private String botVersion;
        private String localeId;
        private String generationStatus;
        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBotResourceGenerationResponse model) {
            super(model);
            this.generationInputPrompt(model.generationInputPrompt);
            this.generationId(model.generationId);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.generationStatus(model.generationStatus);
            this.creationDateTime(model.creationDateTime);
        }

        public final String getGenerationInputPrompt() {
            return this.generationInputPrompt;
        }

        public final void setGenerationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
        }

        @Override
        public final Builder generationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
            return this;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getGenerationStatus() {
            return this.generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public StartBotResourceGenerationResponse build() {
            return new StartBotResourceGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBotResourceGenerationResponse> {
        public Builder generationInputPrompt(String var1);

        public Builder generationId(String var1);

        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder generationStatus(String var1);

        public Builder generationStatus(GenerationStatus var1);

        public Builder creationDateTime(Instant var1);
    }
}

