/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript;
import software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscriptListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAssociatedTranscriptsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, SearchAssociatedTranscriptsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::botId)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::botVersion)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::localeId)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botRecommendationId").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::botRecommendationId)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::botRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build()}).build();
    private static final SdkField<Integer> NEXT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nextIndex").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::nextIndex)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::nextIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextIndex").build()}).build();
    private static final SdkField<List<AssociatedTranscript>> ASSOCIATED_TRANSCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedTranscripts").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::associatedTranscripts)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::associatedTranscripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedTranscripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedTranscript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResults").getter(SearchAssociatedTranscriptsResponse.getter(SearchAssociatedTranscriptsResponse::totalResults)).setter(SearchAssociatedTranscriptsResponse.setter(Builder::totalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_ID_FIELD, NEXT_INDEX_FIELD, ASSOCIATED_TRANSCRIPTS_FIELD, TOTAL_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("botRecommendationId", BOT_RECOMMENDATION_ID_FIELD);
            this.put("nextIndex", NEXT_INDEX_FIELD);
            this.put("associatedTranscripts", ASSOCIATED_TRANSCRIPTS_FIELD);
            this.put("totalResults", TOTAL_RESULTS_FIELD);
        }
    });
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String botRecommendationId;
    private final Integer nextIndex;
    private final List<AssociatedTranscript> associatedTranscripts;
    private final Integer totalResults;

    private SearchAssociatedTranscriptsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationId = builder.botRecommendationId;
        this.nextIndex = builder.nextIndex;
        this.associatedTranscripts = builder.associatedTranscripts;
        this.totalResults = builder.totalResults;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String botRecommendationId() {
        return this.botRecommendationId;
    }

    public final Integer nextIndex() {
        return this.nextIndex;
    }

    public final boolean hasAssociatedTranscripts() {
        return this.associatedTranscripts != null && !(this.associatedTranscripts instanceof SdkAutoConstructList);
    }

    public final List<AssociatedTranscript> associatedTranscripts() {
        return this.associatedTranscripts;
    }

    public final Integer totalResults() {
        return this.totalResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedTranscripts() ? this.associatedTranscripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAssociatedTranscriptsResponse)) {
            return false;
        }
        SearchAssociatedTranscriptsResponse other = (SearchAssociatedTranscriptsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.botRecommendationId(), other.botRecommendationId()) && Objects.equals(this.nextIndex(), other.nextIndex()) && this.hasAssociatedTranscripts() == other.hasAssociatedTranscripts() && Objects.equals(this.associatedTranscripts(), other.associatedTranscripts()) && Objects.equals(this.totalResults(), other.totalResults());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAssociatedTranscriptsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("BotRecommendationId", (Object)this.botRecommendationId()).add("NextIndex", (Object)this.nextIndex()).add("AssociatedTranscripts", this.hasAssociatedTranscripts() ? this.associatedTranscripts() : null).add("TotalResults", (Object)this.totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "botRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationId()));
            }
            case "nextIndex": {
                return Optional.ofNullable(clazz.cast(this.nextIndex()));
            }
            case "associatedTranscripts": {
                return Optional.ofNullable(clazz.cast(this.associatedTranscripts()));
            }
            case "totalResults": {
                return Optional.ofNullable(clazz.cast(this.totalResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchAssociatedTranscriptsResponse, T> g) {
        return obj -> g.apply((SearchAssociatedTranscriptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String botRecommendationId;
        private Integer nextIndex;
        private List<AssociatedTranscript> associatedTranscripts = DefaultSdkAutoConstructList.getInstance();
        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAssociatedTranscriptsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.botRecommendationId(model.botRecommendationId);
            this.nextIndex(model.nextIndex);
            this.associatedTranscripts(model.associatedTranscripts);
            this.totalResults(model.totalResults);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationId() {
            return this.botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final Integer getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
        }

        @Override
        public final Builder nextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
            return this;
        }

        public final List<AssociatedTranscript.Builder> getAssociatedTranscripts() {
            List<AssociatedTranscript.Builder> result = AssociatedTranscriptListCopier.copyToBuilder(this.associatedTranscripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedTranscripts(Collection<AssociatedTranscript.BuilderImpl> associatedTranscripts) {
            this.associatedTranscripts = AssociatedTranscriptListCopier.copyFromBuilder(associatedTranscripts);
        }

        @Override
        public final Builder associatedTranscripts(Collection<AssociatedTranscript> associatedTranscripts) {
            this.associatedTranscripts = AssociatedTranscriptListCopier.copy(associatedTranscripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTranscripts(AssociatedTranscript ... associatedTranscripts) {
            this.associatedTranscripts(Arrays.asList(associatedTranscripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTranscripts(Consumer<AssociatedTranscript.Builder> ... associatedTranscripts) {
            this.associatedTranscripts(Stream.of(associatedTranscripts).map(c -> (AssociatedTranscript)((AssociatedTranscript.Builder)AssociatedTranscript.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalResults() {
            return this.totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchAssociatedTranscriptsResponse build() {
            return new SearchAssociatedTranscriptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAssociatedTranscriptsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder botRecommendationId(String var1);

        public Builder nextIndex(Integer var1);

        public Builder associatedTranscripts(Collection<AssociatedTranscript> var1);

        public Builder associatedTranscripts(AssociatedTranscript ... var1);

        public Builder associatedTranscripts(Consumer<AssociatedTranscript.Builder> ... var1);

        public Builder totalResults(Integer var1);
    }
}

