/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotReplicaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotReplicaSummary> {
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicaRegion").getter(BotReplicaSummary.getter(BotReplicaSummary::replicaRegion)).setter(BotReplicaSummary.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BotReplicaSummary.getter(BotReplicaSummary::creationDateTime)).setter(BotReplicaSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> BOT_REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botReplicaStatus").getter(BotReplicaSummary.getter(BotReplicaSummary::botReplicaStatusAsString)).setter(BotReplicaSummary.setter(Builder::botReplicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(BotReplicaSummary.getter(BotReplicaSummary::failureReasons)).setter(BotReplicaSummary.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICA_REGION_FIELD, CREATION_DATE_TIME_FIELD, BOT_REPLICA_STATUS_FIELD, FAILURE_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("replicaRegion", REPLICA_REGION_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("botReplicaStatus", BOT_REPLICA_STATUS_FIELD);
            this.put("failureReasons", FAILURE_REASONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicaRegion;
    private final Instant creationDateTime;
    private final String botReplicaStatus;
    private final List<String> failureReasons;

    private BotReplicaSummary(BuilderImpl builder) {
        this.replicaRegion = builder.replicaRegion;
        this.creationDateTime = builder.creationDateTime;
        this.botReplicaStatus = builder.botReplicaStatus;
        this.failureReasons = builder.failureReasons;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final BotReplicaStatus botReplicaStatus() {
        return BotReplicaStatus.fromValue(this.botReplicaStatus);
    }

    public final String botReplicaStatusAsString() {
        return this.botReplicaStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.botReplicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotReplicaSummary)) {
            return false;
        }
        BotReplicaSummary other = (BotReplicaSummary)obj;
        return Objects.equals(this.replicaRegion(), other.replicaRegion()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.botReplicaStatusAsString(), other.botReplicaStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons());
    }

    public final String toString() {
        return ToString.builder((String)"BotReplicaSummary").add("ReplicaRegion", (Object)this.replicaRegion()).add("CreationDateTime", (Object)this.creationDateTime()).add("BotReplicaStatus", (Object)this.botReplicaStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "botReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.botReplicaStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BotReplicaSummary, T> g) {
        return obj -> g.apply((BotReplicaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicaRegion;
        private Instant creationDateTime;
        private String botReplicaStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotReplicaSummary model) {
            this.replicaRegion(model.replicaRegion);
            this.creationDateTime(model.creationDateTime);
            this.botReplicaStatus(model.botReplicaStatus);
            this.failureReasons(model.failureReasons);
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getBotReplicaStatus() {
            return this.botReplicaStatus;
        }

        public final void setBotReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
        }

        @Override
        public final Builder botReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
            return this;
        }

        @Override
        public final Builder botReplicaStatus(BotReplicaStatus botReplicaStatus) {
            this.botReplicaStatus(botReplicaStatus == null ? null : botReplicaStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public BotReplicaSummary build() {
            return new BotReplicaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotReplicaSummary> {
        public Builder replicaRegion(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder botReplicaStatus(String var1);

        public Builder botReplicaStatus(BotReplicaStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);
    }
}

