/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateCustomVocabularyItemsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.NewCustomVocabularyItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateCustomVocabularyItemRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, BatchCreateCustomVocabularyItemRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(BatchCreateCustomVocabularyItemRequest.getter(BatchCreateCustomVocabularyItemRequest::botId)).setter(BatchCreateCustomVocabularyItemRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BatchCreateCustomVocabularyItemRequest.getter(BatchCreateCustomVocabularyItemRequest::botVersion)).setter(BatchCreateCustomVocabularyItemRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(BatchCreateCustomVocabularyItemRequest.getter(BatchCreateCustomVocabularyItemRequest::localeId)).setter(BatchCreateCustomVocabularyItemRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<List<NewCustomVocabularyItem>> CUSTOM_VOCABULARY_ITEM_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customVocabularyItemList").getter(BatchCreateCustomVocabularyItemRequest.getter(BatchCreateCustomVocabularyItemRequest::customVocabularyItemList)).setter(BatchCreateCustomVocabularyItemRequest.setter(Builder::customVocabularyItemList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customVocabularyItemList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NewCustomVocabularyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, CUSTOM_VOCABULARY_ITEM_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("customVocabularyItemList", CUSTOM_VOCABULARY_ITEM_LIST_FIELD);
        }
    });
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final List<NewCustomVocabularyItem> customVocabularyItemList;

    private BatchCreateCustomVocabularyItemRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.customVocabularyItemList = builder.customVocabularyItemList;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final boolean hasCustomVocabularyItemList() {
        return this.customVocabularyItemList != null && !(this.customVocabularyItemList instanceof SdkAutoConstructList);
    }

    public final List<NewCustomVocabularyItem> customVocabularyItemList() {
        return this.customVocabularyItemList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomVocabularyItemList() ? this.customVocabularyItemList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateCustomVocabularyItemRequest)) {
            return false;
        }
        BatchCreateCustomVocabularyItemRequest other = (BatchCreateCustomVocabularyItemRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && this.hasCustomVocabularyItemList() == other.hasCustomVocabularyItemList() && Objects.equals(this.customVocabularyItemList(), other.customVocabularyItemList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateCustomVocabularyItemRequest").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("CustomVocabularyItemList", this.hasCustomVocabularyItemList() ? this.customVocabularyItemList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "customVocabularyItemList": {
                return Optional.ofNullable(clazz.cast(this.customVocabularyItemList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateCustomVocabularyItemRequest, T> g) {
        return obj -> g.apply((BatchCreateCustomVocabularyItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private List<NewCustomVocabularyItem> customVocabularyItemList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateCustomVocabularyItemRequest model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.customVocabularyItemList(model.customVocabularyItemList);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<NewCustomVocabularyItem.Builder> getCustomVocabularyItemList() {
            List<NewCustomVocabularyItem.Builder> result = CreateCustomVocabularyItemsListCopier.copyToBuilder(this.customVocabularyItemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomVocabularyItemList(Collection<NewCustomVocabularyItem.BuilderImpl> customVocabularyItemList) {
            this.customVocabularyItemList = CreateCustomVocabularyItemsListCopier.copyFromBuilder(customVocabularyItemList);
        }

        @Override
        public final Builder customVocabularyItemList(Collection<NewCustomVocabularyItem> customVocabularyItemList) {
            this.customVocabularyItemList = CreateCustomVocabularyItemsListCopier.copy(customVocabularyItemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItemList(NewCustomVocabularyItem ... customVocabularyItemList) {
            this.customVocabularyItemList(Arrays.asList(customVocabularyItemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVocabularyItemList(Consumer<NewCustomVocabularyItem.Builder> ... customVocabularyItemList) {
            this.customVocabularyItemList(Stream.of(customVocabularyItemList).map(c -> (NewCustomVocabularyItem)((NewCustomVocabularyItem.Builder)NewCustomVocabularyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateCustomVocabularyItemRequest build() {
            return new BatchCreateCustomVocabularyItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateCustomVocabularyItemRequest> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder customVocabularyItemList(Collection<NewCustomVocabularyItem> var1);

        public Builder customVocabularyItemList(NewCustomVocabularyItem ... var1);

        public Builder customVocabularyItemList(Consumer<NewCustomVocabularyItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

