/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotSummary> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotId").getter(SlotSummary.getter(SlotSummary::slotId)).setter(SlotSummary.setter(Builder::slotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotId").build()}).build();
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotName").getter(SlotSummary.getter(SlotSummary::slotName)).setter(SlotSummary.setter(Builder::slotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SlotSummary.getter(SlotSummary::description)).setter(SlotSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotConstraint").getter(SlotSummary.getter(SlotSummary::slotConstraintAsString)).setter(SlotSummary.setter(Builder::slotConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()}).build();
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotTypeId").getter(SlotSummary.getter(SlotSummary::slotTypeId)).setter(SlotSummary.setter(Builder::slotTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()}).build();
    private static final SdkField<PromptSpecification> VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("valueElicitationPromptSpecification").getter(SlotSummary.getter(SlotSummary::valueElicitationPromptSpecification)).setter(SlotSummary.setter(Builder::valueElicitationPromptSpecification)).constructor(PromptSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueElicitationPromptSpecification").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(SlotSummary.getter(SlotSummary::lastUpdatedDateTime)).setter(SlotSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD, SLOT_NAME_FIELD, DESCRIPTION_FIELD, SLOT_CONSTRAINT_FIELD, SLOT_TYPE_ID_FIELD, VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SlotSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String slotId;
    private final String slotName;
    private final String description;
    private final String slotConstraint;
    private final String slotTypeId;
    private final PromptSpecification valueElicitationPromptSpecification;
    private final Instant lastUpdatedDateTime;

    private SlotSummary(BuilderImpl builder) {
        this.slotId = builder.slotId;
        this.slotName = builder.slotName;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotTypeId = builder.slotTypeId;
        this.valueElicitationPromptSpecification = builder.valueElicitationPromptSpecification;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String slotId() {
        return this.slotId;
    }

    public final String slotName() {
        return this.slotName;
    }

    public final String description() {
        return this.description;
    }

    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(this.slotConstraint);
    }

    public final String slotConstraintAsString() {
        return this.slotConstraint;
    }

    public final String slotTypeId() {
        return this.slotTypeId;
    }

    public final PromptSpecification valueElicitationPromptSpecification() {
        return this.valueElicitationPromptSpecification;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueElicitationPromptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotSummary)) {
            return false;
        }
        SlotSummary other = (SlotSummary)obj;
        return Objects.equals(this.slotId(), other.slotId()) && Objects.equals(this.slotName(), other.slotName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.slotConstraintAsString(), other.slotConstraintAsString()) && Objects.equals(this.slotTypeId(), other.slotTypeId()) && Objects.equals(this.valueElicitationPromptSpecification(), other.valueElicitationPromptSpecification()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"SlotSummary").add("SlotId", (Object)this.slotId()).add("SlotName", (Object)this.slotName()).add("Description", (Object)this.description()).add("SlotConstraint", (Object)this.slotConstraintAsString()).add("SlotTypeId", (Object)this.slotTypeId()).add("ValueElicitationPromptSpecification", (Object)this.valueElicitationPromptSpecification()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "slotId": {
                return Optional.ofNullable(clazz.cast(this.slotId()));
            }
            case "slotName": {
                return Optional.ofNullable(clazz.cast(this.slotName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "slotConstraint": {
                return Optional.ofNullable(clazz.cast(this.slotConstraintAsString()));
            }
            case "slotTypeId": {
                return Optional.ofNullable(clazz.cast(this.slotTypeId()));
            }
            case "valueElicitationPromptSpecification": {
                return Optional.ofNullable(clazz.cast(this.valueElicitationPromptSpecification()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("slotId", SLOT_ID_FIELD);
        map.put("slotName", SLOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("slotConstraint", SLOT_CONSTRAINT_FIELD);
        map.put("slotTypeId", SLOT_TYPE_ID_FIELD);
        map.put("valueElicitationPromptSpecification", VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotSummary, T> g) {
        return obj -> g.apply((SlotSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String slotId;
        private String slotName;
        private String description;
        private String slotConstraint;
        private String slotTypeId;
        private PromptSpecification valueElicitationPromptSpecification;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotSummary model) {
            this.slotId(model.slotId);
            this.slotName(model.slotName);
            this.description(model.description);
            this.slotConstraint(model.slotConstraint);
            this.slotTypeId(model.slotTypeId);
            this.valueElicitationPromptSpecification(model.valueElicitationPromptSpecification);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getSlotId() {
            return this.slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getSlotName() {
            return this.slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final String getSlotTypeId() {
            return this.slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final PromptSpecification.Builder getValueElicitationPromptSpecification() {
            return this.valueElicitationPromptSpecification != null ? this.valueElicitationPromptSpecification.toBuilder() : null;
        }

        public final void setValueElicitationPromptSpecification(PromptSpecification.BuilderImpl valueElicitationPromptSpecification) {
            this.valueElicitationPromptSpecification = valueElicitationPromptSpecification != null ? valueElicitationPromptSpecification.build() : null;
        }

        @Override
        public final Builder valueElicitationPromptSpecification(PromptSpecification valueElicitationPromptSpecification) {
            this.valueElicitationPromptSpecification = valueElicitationPromptSpecification;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public SlotSummary build() {
            return new SlotSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotSummary> {
        public Builder slotId(String var1);

        public Builder slotName(String var1);

        public Builder description(String var1);

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder slotTypeId(String var1);

        public Builder valueElicitationPromptSpecification(PromptSpecification var1);

        default public Builder valueElicitationPromptSpecification(Consumer<PromptSpecification.Builder> valueElicitationPromptSpecification) {
            return this.valueElicitationPromptSpecification((PromptSpecification)((PromptSpecification.Builder)PromptSpecification.builder().applyMutation(valueElicitationPromptSpecification)).build());
        }

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

