/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher;

/**
 * Service client for accessing Lex Models V2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LexModelsV2AsyncClient extends SdkClient {
    String SERVICE_NAME = "lex";

    /**
     * Create a {@link LexModelsV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LexModelsV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LexModelsV2AsyncClient}.
     */
    static LexModelsV2AsyncClientBuilder builder() {
        return new DefaultLexModelsV2AsyncClientBuilder();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return A Java Future containing the result of the BuildBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BuildBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BuildBotLocaleResponse> buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildBotLocaleRequest.Builder} avoiding the need to
     * create one manually via {@link BuildBotLocaleRequest#builder()}
     * </p>
     *
     * @param buildBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link BuildBotLocaleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BuildBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.BuildBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BuildBotLocaleResponse> buildBotLocale(Consumer<BuildBotLocaleRequest.Builder> buildBotLocaleRequest) {
        return buildBotLocale(BuildBotLocaleRequest.builder().applyMutation(buildBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(CreateBotRequest createBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotRequest#builder()}
     * </p>
     *
     * @param createBotRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBotResponse> createBot(Consumer<CreateBotRequest.Builder> createBotRequest) {
        return createBot(CreateBotRequest.builder().applyMutation(createBotRequest).build());
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return A Java Future containing the result of the CreateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotAliasResponse> createBotAlias(CreateBotAliasRequest createBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotAliasRequest#builder()}
     * </p>
     *
     * @param createBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotAliasResponse> createBotAlias(Consumer<CreateBotAliasRequest.Builder> createBotAliasRequest) {
        return createBotAlias(CreateBotAliasRequest.builder().applyMutation(createBotAliasRequest).build());
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return A Java Future containing the result of the CreateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotLocaleResponse> createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotLocaleRequest#builder()}
     * </p>
     *
     * @param createBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotLocaleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotLocaleResponse> createBotLocale(
            Consumer<CreateBotLocaleRequest.Builder> createBotLocaleRequest) {
        return createBotLocale(CreateBotLocaleRequest.builder().applyMutation(createBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotVersionResponse> createBotVersion(CreateBotVersionRequest createBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotVersionRequest#builder()}
     * </p>
     *
     * @param createBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBotVersionResponse> createBotVersion(
            Consumer<CreateBotVersionRequest.Builder> createBotVersionRequest) {
        return createBotVersion(CreateBotVersionRequest.builder().applyMutation(createBotVersionRequest).build());
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return A Java Future containing the result of the CreateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntentResponse> createIntent(CreateIntentRequest createIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIntentRequest#builder()}
     * </p>
     *
     * @param createIntentRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntentResponse> createIntent(Consumer<CreateIntentRequest.Builder> createIntentRequest) {
        return createIntent(CreateIntentRequest.builder().applyMutation(createIntentRequest).build());
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return A Java Future containing the result of the CreateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSlotResponse> createSlot(CreateSlotRequest createSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotRequest#builder()}
     * </p>
     *
     * @param createSlotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSlotResponse> createSlot(Consumer<CreateSlotRequest.Builder> createSlotRequest) {
        return createSlot(CreateSlotRequest.builder().applyMutation(createSlotRequest).build());
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return A Java Future containing the result of the CreateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSlotTypeResponse> createSlotType(CreateSlotTypeRequest createSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotTypeRequest#builder()}
     * </p>
     *
     * @param createSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.CreateSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSlotTypeResponse> createSlotType(Consumer<CreateSlotTypeRequest.Builder> createSlotTypeRequest) {
        return createSlotType(CreateSlotTypeRequest.builder().applyMutation(createSlotTypeRequest).build());
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBotResponse> deleteBot(DeleteBotRequest deleteBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotRequest#builder()}
     * </p>
     *
     * @param deleteBotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBotResponse> deleteBot(Consumer<DeleteBotRequest.Builder> deleteBotRequest) {
        return deleteBot(DeleteBotRequest.builder().applyMutation(deleteBotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotAliasRequest#builder()}
     * </p>
     *
     * @param deleteBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotAliasResponse> deleteBotAlias(Consumer<DeleteBotAliasRequest.Builder> deleteBotAliasRequest) {
        return deleteBotAlias(DeleteBotAliasRequest.builder().applyMutation(deleteBotAliasRequest).build());
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return A Java Future containing the result of the DeleteBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotLocaleResponse> deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotLocaleRequest#builder()}
     * </p>
     *
     * @param deleteBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotLocaleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotLocaleResponse> deleteBotLocale(
            Consumer<DeleteBotLocaleRequest.Builder> deleteBotLocaleRequest) {
        return deleteBotLocale(DeleteBotLocaleRequest.builder().applyMutation(deleteBotLocaleRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all version of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all version of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotVersionRequest#builder()}
     * </p>
     *
     * @param deleteBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBotVersionResponse> deleteBotVersion(
            Consumer<DeleteBotVersionRequest.Builder> deleteBotVersionRequest) {
        return deleteBotVersion(DeleteBotVersionRequest.builder().applyMutation(deleteBotVersionRequest).build());
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntentResponse> deleteIntent(DeleteIntentRequest deleteIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIntentRequest#builder()}
     * </p>
     *
     * @param deleteIntentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntentResponse> deleteIntent(Consumer<DeleteIntentRequest.Builder> deleteIntentRequest) {
        return deleteIntent(DeleteIntentRequest.builder().applyMutation(deleteIntentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return A Java Future containing the result of the DeleteSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSlotResponse> deleteSlot(DeleteSlotRequest deleteSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotRequest#builder()}
     * </p>
     *
     * @param deleteSlotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSlotResponse> deleteSlot(Consumer<DeleteSlotRequest.Builder> deleteSlotRequest) {
        return deleteSlot(DeleteSlotRequest.builder().applyMutation(deleteSlotRequest).build());
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotTypeRequest#builder()}
     * </p>
     *
     * @param deleteSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ConflictException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DeleteSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSlotTypeResponse> deleteSlotType(Consumer<DeleteSlotTypeRequest.Builder> deleteSlotTypeRequest) {
        return deleteSlotType(DeleteSlotTypeRequest.builder().applyMutation(deleteSlotTypeRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return A Java Future containing the result of the DescribeBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBotResponse> describeBot(DescribeBotRequest describeBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBotRequest#builder()}
     * </p>
     *
     * @param describeBotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBotResponse> describeBot(Consumer<DescribeBotRequest.Builder> describeBotRequest) {
        return describeBot(DescribeBotRequest.builder().applyMutation(describeBotRequest).build());
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return A Java Future containing the result of the DescribeBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBotAliasResponse> describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotAliasRequest#builder()}
     * </p>
     *
     * @param describeBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBotAliasResponse> describeBotAlias(
            Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest) {
        return describeBotAlias(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build());
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return A Java Future containing the result of the DescribeBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotLocaleResponse> describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotLocaleRequest#builder()}
     * </p>
     *
     * @param describeBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotLocaleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotLocaleResponse> describeBotLocale(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest) {
        return describeBotLocale(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return A Java Future containing the result of the DescribeBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotVersionResponse> describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBotVersionRequest#builder()}
     * </p>
     *
     * @param describeBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBotVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBotVersionResponse> describeBotVersion(
            Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest) {
        return describeBotVersion(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build());
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return A Java Future containing the result of the DescribeIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIntentResponse> describeIntent(DescribeIntentRequest describeIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIntentRequest#builder()}
     * </p>
     *
     * @param describeIntentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeIntentResponse> describeIntent(Consumer<DescribeIntentRequest.Builder> describeIntentRequest) {
        return describeIntent(DescribeIntentRequest.builder().applyMutation(describeIntentRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return A Java Future containing the result of the DescribeSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSlotResponse> describeSlot(DescribeSlotRequest describeSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSlotRequest#builder()}
     * </p>
     *
     * @param describeSlotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSlotResponse> describeSlot(Consumer<DescribeSlotRequest.Builder> describeSlotRequest) {
        return describeSlot(DescribeSlotRequest.builder().applyMutation(describeSlotRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return A Java Future containing the result of the DescribeSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSlotTypeResponse> describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSlotTypeRequest#builder()}
     * </p>
     *
     * @param describeSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.DescribeSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSlotTypeResponse> describeSlotType(
            Consumer<DescribeSlotTypeRequest.Builder> describeSlotTypeRequest) {
        return describeSlotType(DescribeSlotTypeRequest.builder().applyMutation(describeSlotTypeRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A Java Future containing the result of the ListBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotAliasesResponse> listBotAliases(ListBotAliasesRequest listBotAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBotAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotAliasesResponse> listBotAliases(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest) {
        return listBotAliases(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesPublisher listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesPublisher publisher = client.listBotAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesPublisher listBotAliasesPaginator(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest) {
        return listBotAliasesPaginator(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A Java Future containing the result of the ListBotLocales operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotLocalesResponse> listBotLocales(ListBotLocalesRequest listBotLocalesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBotLocales operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotLocalesResponse> listBotLocales(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest) {
        return listBotLocales(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesPublisher listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesPublisher publisher = client.listBotLocalesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotLocales
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesPublisher listBotLocalesPaginator(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest) {
        return listBotLocalesPaginator(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A Java Future containing the result of the ListBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotVersionsResponse> listBotVersions(ListBotVersionsRequest listBotVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBotVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBotVersionsResponse> listBotVersions(
            Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest) {
        return listBotVersions(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsPublisher listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsPublisher publisher = client.listBotVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsPublisher listBotVersionsPaginator(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest) {
        return listBotVersionsPaginator(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(ListBotsRequest listBotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBotsResponse> listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(ListBotsRequest listBotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsPublisher publisher = client.listBotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsPublisher listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest) {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A Java Future containing the result of the ListBuiltInIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInIntentsResponse> listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuiltInIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInIntentsResponse> listBuiltInIntents(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) {
        return listBuiltInIntents(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsPublisher listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsPublisher publisher = client.listBuiltInIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsPublisher listBuiltInIntentsPaginator(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) {
        return listBuiltInIntentsPaginator(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A Java Future containing the result of the ListBuiltInSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInSlotTypesResponse> listBuiltInSlotTypes(
            ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuiltInSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuiltInSlotTypesResponse> listBuiltInSlotTypes(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) {
        return listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesPublisher listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesPublisher publisher = client.listBuiltInSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListBuiltInSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesPublisher listBuiltInSlotTypesPaginator(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) {
        return listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest)
                .build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return A Java Future containing the result of the ListIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIntentsResponse> listIntents(ListIntentsRequest listIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIntents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIntentsResponse> listIntents(Consumer<ListIntentsRequest.Builder> listIntentsRequest) {
        return listIntents(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     *
     * @param listIntentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsPublisher listIntentsPaginator(ListIntentsRequest listIntentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsPublisher publisher = client.listIntentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsPublisher listIntentsPaginator(Consumer<ListIntentsRequest.Builder> listIntentsRequest) {
        return listIntentsPaginator(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A Java Future containing the result of the ListSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSlotTypesResponse> listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSlotTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSlotTypesResponse> listSlotTypes(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest) {
        return listSlotTypes(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesPublisher listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesPublisher publisher = client.listSlotTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesPublisher listSlotTypesPaginator(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest) {
        return listSlotTypesPaginator(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return A Java Future containing the result of the ListSlots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSlotsResponse> listSlots(ListSlotsRequest listSlotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSlots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSlotsResponse> listSlots(Consumer<ListSlotsRequest.Builder> listSlotsRequest) {
        return listSlots(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     *
     * @param listSlotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsPublisher listSlotsPaginator(ListSlotsRequest listSlotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsPublisher publisher = client.listSlotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListSlots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsPublisher listSlotsPaginator(Consumer<ListSlotsRequest.Builder> listSlotsRequest) {
        return listSlotsPaginator(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException</li>
     *         <li>ThrottlingException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(UpdateBotRequest updateBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotRequest#builder()}
     * </p>
     *
     * @param updateBotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBotResponse> updateBot(Consumer<UpdateBotRequest.Builder> updateBotRequest) {
        return updateBot(UpdateBotRequest.builder().applyMutation(updateBotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return A Java Future containing the result of the UpdateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotAliasResponse> updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotAliasRequest#builder()}
     * </p>
     *
     * @param updateBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBotAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotAliasResponse> updateBotAlias(Consumer<UpdateBotAliasRequest.Builder> updateBotAliasRequest) {
        return updateBotAlias(UpdateBotAliasRequest.builder().applyMutation(updateBotAliasRequest).build());
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return A Java Future containing the result of the UpdateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotLocaleResponse> updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBotLocaleRequest#builder()}
     * </p>
     *
     * @param updateBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotLocaleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBotLocale operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateBotLocale
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBotLocaleResponse> updateBotLocale(
            Consumer<UpdateBotLocaleRequest.Builder> updateBotLocaleRequest) {
        return updateBotLocale(UpdateBotLocaleRequest.builder().applyMutation(updateBotLocaleRequest).build());
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return A Java Future containing the result of the UpdateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIntentResponse> updateIntent(UpdateIntentRequest updateIntentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIntentRequest#builder()}
     * </p>
     *
     * @param updateIntentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIntent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIntentResponse> updateIntent(Consumer<UpdateIntentRequest.Builder> updateIntentRequest) {
        return updateIntent(UpdateIntentRequest.builder().applyMutation(updateIntentRequest).build());
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return A Java Future containing the result of the UpdateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSlotResponse> updateSlot(UpdateSlotRequest updateSlotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotRequest#builder()}
     * </p>
     *
     * @param updateSlotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSlot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSlotResponse> updateSlot(Consumer<UpdateSlotRequest.Builder> updateSlotRequest) {
        return updateSlot(UpdateSlotRequest.builder().applyMutation(updateSlotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return A Java Future containing the result of the UpdateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSlotTypeResponse> updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotTypeRequest#builder()}
     * </p>
     *
     * @param updateSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSlotType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ValidationException</li>
     *         <li>PreconditionFailedException</li>
     *         <li>ConflictException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LexModelsV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LexModelsV2AsyncClient.UpdateSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSlotTypeResponse> updateSlotType(Consumer<UpdateSlotTypeRequest.Builder> updateSlotTypeRequest) {
        return updateSlotType(UpdateSlotTypeRequest.builder().applyMutation(updateSlotTypeRequest).build());
    }
}
