/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MergeStrategy {
    OVERWRITE_LATEST("OVERWRITE_LATEST"),
    FAIL_ON_CONFLICT("FAIL_ON_CONFLICT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MergeStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MergeStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MergeStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MergeStrategy> knownValues() {
        return Stream.of(MergeStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

