/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotAliasMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotAliasMetadataListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBotAliasesResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBotAliasesResponse> {
    private static final SdkField<List<BotAliasMetadata>> BOT_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BotAliases").getter(GetBotAliasesResponse.getter(GetBotAliasesResponse::botAliases)).setter(GetBotAliasesResponse.setter(Builder::botAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotAliasMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetBotAliasesResponse.getter(GetBotAliasesResponse::nextToken)).setter(GetBotAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIASES_FIELD, NEXT_TOKEN_FIELD));
    private final List<BotAliasMetadata> botAliases;
    private final String nextToken;

    private GetBotAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.botAliases = builder.botAliases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBotAliases() {
        return this.botAliases != null && !(this.botAliases instanceof SdkAutoConstructList);
    }

    public final List<BotAliasMetadata> botAliases() {
        return this.botAliases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotAliases() ? this.botAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotAliasesResponse)) {
            return false;
        }
        GetBotAliasesResponse other = (GetBotAliasesResponse)((Object)obj);
        return this.hasBotAliases() == other.hasBotAliases() && Objects.equals(this.botAliases(), other.botAliases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBotAliasesResponse").add("BotAliases", this.hasBotAliases() ? this.botAliases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BotAliases": {
                return Optional.ofNullable(clazz.cast(this.botAliases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotAliasesResponse, T> g) {
        return obj -> g.apply((GetBotAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<BotAliasMetadata> botAliases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotAliasesResponse model) {
            super(model);
            this.botAliases(model.botAliases);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotAliasMetadata.Builder> getBotAliases() {
            if (this.botAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.botAliases != null ? (Collection)this.botAliases.stream().map(BotAliasMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botAliases(Collection<BotAliasMetadata> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copy(botAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliases(BotAliasMetadata ... botAliases) {
            this.botAliases(Arrays.asList(botAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botAliases(Consumer<BotAliasMetadata.Builder> ... botAliases) {
            this.botAliases(Stream.of(botAliases).map(c -> (BotAliasMetadata)((BotAliasMetadata.Builder)BotAliasMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBotAliases(Collection<BotAliasMetadata.BuilderImpl> botAliases) {
            this.botAliases = BotAliasMetadataListCopier.copyFromBuilder(botAliases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotAliasesResponse build() {
            return new GetBotAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBotAliasesResponse> {
        public Builder botAliases(Collection<BotAliasMetadata> var1);

        public Builder botAliases(BotAliasMetadata ... var1);

        public Builder botAliases(Consumer<BotAliasMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

