/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.launchwizard.LaunchWizardClient;
import software.amazon.awssdk.services.launchwizard.internal.UserAgentUtils;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary;

public class ListWorkloadDeploymentPatternsIterable
implements SdkIterable<ListWorkloadDeploymentPatternsResponse> {
    private final LaunchWizardClient client;
    private final ListWorkloadDeploymentPatternsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadDeploymentPatternsIterable(LaunchWizardClient client, ListWorkloadDeploymentPatternsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadDeploymentPatternsResponseFetcher();
    }

    public Iterator<ListWorkloadDeploymentPatternsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns() {
        Function<ListWorkloadDeploymentPatternsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workloadDeploymentPatterns() != null) {
                return response.workloadDeploymentPatterns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkloadDeploymentPatternsResponseFetcher
    implements SyncPageFetcher<ListWorkloadDeploymentPatternsResponse> {
        private ListWorkloadDeploymentPatternsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadDeploymentPatternsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadDeploymentPatternsResponse nextPage(ListWorkloadDeploymentPatternsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadDeploymentPatternsIterable.this.client.listWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsIterable.this.firstRequest);
            }
            return ListWorkloadDeploymentPatternsIterable.this.client.listWorkloadDeploymentPatterns((ListWorkloadDeploymentPatternsRequest)((Object)ListWorkloadDeploymentPatternsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

