/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRuntimeManagementConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, PutRuntimeManagementConfigResponse> {
    private static final SdkField<String> UPDATE_RUNTIME_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateRuntimeOn").getter(PutRuntimeManagementConfigResponse.getter(PutRuntimeManagementConfigResponse::updateRuntimeOnAsString)).setter(PutRuntimeManagementConfigResponse.setter(Builder::updateRuntimeOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRuntimeOn").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(PutRuntimeManagementConfigResponse.getter(PutRuntimeManagementConfigResponse::functionArn)).setter(PutRuntimeManagementConfigResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersionArn").getter(PutRuntimeManagementConfigResponse.getter(PutRuntimeManagementConfigResponse::runtimeVersionArn)).setter(PutRuntimeManagementConfigResponse.setter(Builder::runtimeVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_RUNTIME_ON_FIELD, FUNCTION_ARN_FIELD, RUNTIME_VERSION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRuntimeManagementConfigResponse.memberNameToFieldInitializer();
    private final String updateRuntimeOn;
    private final String functionArn;
    private final String runtimeVersionArn;

    private PutRuntimeManagementConfigResponse(BuilderImpl builder) {
        super(builder);
        this.updateRuntimeOn = builder.updateRuntimeOn;
        this.functionArn = builder.functionArn;
        this.runtimeVersionArn = builder.runtimeVersionArn;
    }

    public final UpdateRuntimeOn updateRuntimeOn() {
        return UpdateRuntimeOn.fromValue(this.updateRuntimeOn);
    }

    public final String updateRuntimeOnAsString() {
        return this.updateRuntimeOn;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final String runtimeVersionArn() {
        return this.runtimeVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.updateRuntimeOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuntimeManagementConfigResponse)) {
            return false;
        }
        PutRuntimeManagementConfigResponse other = (PutRuntimeManagementConfigResponse)((Object)obj);
        return Objects.equals(this.updateRuntimeOnAsString(), other.updateRuntimeOnAsString()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.runtimeVersionArn(), other.runtimeVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutRuntimeManagementConfigResponse").add("UpdateRuntimeOn", (Object)this.updateRuntimeOnAsString()).add("FunctionArn", (Object)this.functionArn()).add("RuntimeVersionArn", (Object)this.runtimeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateRuntimeOn": {
                return Optional.ofNullable(clazz.cast(this.updateRuntimeOnAsString()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "RuntimeVersionArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UpdateRuntimeOn", UPDATE_RUNTIME_ON_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("RuntimeVersionArn", RUNTIME_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRuntimeManagementConfigResponse, T> g) {
        return obj -> g.apply((PutRuntimeManagementConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String updateRuntimeOn;
        private String functionArn;
        private String runtimeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuntimeManagementConfigResponse model) {
            super(model);
            this.updateRuntimeOn(model.updateRuntimeOn);
            this.functionArn(model.functionArn);
            this.runtimeVersionArn(model.runtimeVersionArn);
        }

        public final String getUpdateRuntimeOn() {
            return this.updateRuntimeOn;
        }

        public final void setUpdateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
        }

        @Override
        public final Builder updateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
            return this;
        }

        @Override
        public final Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn) {
            this.updateRuntimeOn(updateRuntimeOn == null ? null : updateRuntimeOn.toString());
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getRuntimeVersionArn() {
            return this.runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        @Override
        public PutRuntimeManagementConfigResponse build() {
            return new PutRuntimeManagementConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRuntimeManagementConfigResponse> {
        public Builder updateRuntimeOn(String var1);

        public Builder updateRuntimeOn(UpdateRuntimeOn var1);

        public Builder functionArn(String var1);

        public Builder runtimeVersionArn(String var1);
    }
}

