/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CapacityProviderPredefinedMetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingScalingPolicy> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredefinedMetricType").getter(TargetTrackingScalingPolicy.getter(TargetTrackingScalingPolicy::predefinedMetricTypeAsString)).setter(TargetTrackingScalingPolicy.setter(Builder::predefinedMetricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetValue").getter(TargetTrackingScalingPolicy.getter(TargetTrackingScalingPolicy::targetValue)).setter(TargetTrackingScalingPolicy.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD, TARGET_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetTrackingScalingPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String predefinedMetricType;
    private final Double targetValue;

    private TargetTrackingScalingPolicy(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.targetValue = builder.targetValue;
    }

    public final CapacityProviderPredefinedMetricType predefinedMetricType() {
        return CapacityProviderPredefinedMetricType.fromValue(this.predefinedMetricType);
    }

    public final String predefinedMetricTypeAsString() {
        return this.predefinedMetricType;
    }

    public final Double targetValue() {
        return this.targetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicy)) {
            return false;
        }
        TargetTrackingScalingPolicy other = (TargetTrackingScalingPolicy)obj;
        return Objects.equals(this.predefinedMetricTypeAsString(), other.predefinedMetricTypeAsString()) && Objects.equals(this.targetValue(), other.targetValue());
    }

    public final String toString() {
        return ToString.builder((String)"TargetTrackingScalingPolicy").add("PredefinedMetricType", (Object)this.predefinedMetricTypeAsString()).add("TargetValue", (Object)this.targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedMetricType": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricTypeAsString()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PredefinedMetricType", PREDEFINED_METRIC_TYPE_FIELD);
        map.put("TargetValue", TARGET_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicy, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String predefinedMetricType;
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicy model) {
            this.predefinedMetricType(model.predefinedMetricType);
            this.targetValue(model.targetValue);
        }

        public final String getPredefinedMetricType() {
            return this.predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public final Builder predefinedMetricType(CapacityProviderPredefinedMetricType predefinedMetricType) {
            this.predefinedMetricType(predefinedMetricType == null ? null : predefinedMetricType.toString());
            return this;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public TargetTrackingScalingPolicy build() {
            return new TargetTrackingScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingScalingPolicy> {
        public Builder predefinedMetricType(String var1);

        public Builder predefinedMetricType(CapacityProviderPredefinedMetricType var1);

        public Builder targetValue(Double var1);
    }
}

