/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DurableConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DurableConfig> {
    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriodInDays").getter(DurableConfig.getter(DurableConfig::retentionPeriodInDays)).setter(DurableConfig.setter(Builder::retentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTimeout").getter(DurableConfig.getter(DurableConfig::executionTimeout)).setter(DurableConfig.setter(Builder::executionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_IN_DAYS_FIELD, EXECUTION_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DurableConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer retentionPeriodInDays;
    private final Integer executionTimeout;

    private DurableConfig(BuilderImpl builder) {
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
        this.executionTimeout = builder.executionTimeout;
    }

    public final Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public final Integer executionTimeout() {
        return this.executionTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DurableConfig)) {
            return false;
        }
        DurableConfig other = (DurableConfig)obj;
        return Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays()) && Objects.equals(this.executionTimeout(), other.executionTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"DurableConfig").add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).add("ExecutionTimeout", (Object)this.executionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
            case "ExecutionTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("RetentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        map.put("ExecutionTimeout", EXECUTION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DurableConfig, T> g) {
        return obj -> g.apply((DurableConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer retentionPeriodInDays;
        private Integer executionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(DurableConfig model) {
            this.retentionPeriodInDays(model.retentionPeriodInDays);
            this.executionTimeout(model.executionTimeout);
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final Integer getExecutionTimeout() {
            return this.executionTimeout;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public DurableConfig build() {
            return new DurableConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DurableConfig> {
        public Builder retentionPeriodInDays(Integer var1);

        public Builder executionTimeout(Integer var1);
    }
}

