/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem;
import software.amazon.awssdk.services.lambda.model.ListFunctionVersionsByCapacityProviderRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionVersionsByCapacityProviderResponse;

public class ListFunctionVersionsByCapacityProviderIterable
implements SdkIterable<ListFunctionVersionsByCapacityProviderResponse> {
    private final LambdaClient client;
    private final ListFunctionVersionsByCapacityProviderRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionVersionsByCapacityProviderIterable(LambdaClient client, ListFunctionVersionsByCapacityProviderRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFunctionVersionsByCapacityProviderResponseFetcher();
    }

    public Iterator<ListFunctionVersionsByCapacityProviderResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionVersionsByCapacityProviderListItem> functionVersions() {
        Function<ListFunctionVersionsByCapacityProviderResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionVersions() != null) {
                return response.functionVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFunctionVersionsByCapacityProviderResponseFetcher
    implements SyncPageFetcher<ListFunctionVersionsByCapacityProviderResponse> {
        private ListFunctionVersionsByCapacityProviderResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionVersionsByCapacityProviderResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFunctionVersionsByCapacityProviderResponse nextPage(ListFunctionVersionsByCapacityProviderResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionVersionsByCapacityProviderIterable.this.client.listFunctionVersionsByCapacityProvider(ListFunctionVersionsByCapacityProviderIterable.this.firstRequest);
            }
            return ListFunctionVersionsByCapacityProviderIterable.this.client.listFunctionVersionsByCapacityProvider((ListFunctionVersionsByCapacityProviderRequest)((Object)ListFunctionVersionsByCapacityProviderIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

