/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAliasRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateAliasRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(CreateAliasRequest.getter(CreateAliasRequest::functionName)).setter(CreateAliasRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAliasRequest.getter(CreateAliasRequest::name)).setter(CreateAliasRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionVersion").getter(CreateAliasRequest.getter(CreateAliasRequest::functionVersion)).setter(CreateAliasRequest.setter(Builder::functionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateAliasRequest.getter(CreateAliasRequest::description)).setter(CreateAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AliasRoutingConfiguration> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(CreateAliasRequest.getter(CreateAliasRequest::routingConfig)).setter(CreateAliasRequest.setter(Builder::routingConfig)).constructor(AliasRoutingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, NAME_FIELD, FUNCTION_VERSION_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FunctionName", FUNCTION_NAME_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("FunctionVersion", FUNCTION_VERSION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("RoutingConfig", ROUTING_CONFIG_FIELD);
        }
    });
    private final String functionName;
    private final String name;
    private final String functionVersion;
    private final String description;
    private final AliasRoutingConfiguration routingConfig;

    private CreateAliasRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String name() {
        return this.name;
    }

    public final String functionVersion() {
        return this.functionVersion;
    }

    public final String description() {
        return this.description;
    }

    public final AliasRoutingConfiguration routingConfig() {
        return this.routingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasRequest)) {
            return false;
        }
        CreateAliasRequest other = (CreateAliasRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingConfig(), other.routingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAliasRequest").add("FunctionName", (Object)this.functionName()).add("Name", (Object)this.name()).add("FunctionVersion", (Object)this.functionVersion()).add("Description", (Object)this.description()).add("RoutingConfig", (Object)this.routingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAliasRequest, T> g) {
        return obj -> g.apply((CreateAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String name;
        private String functionVersion;
        private String description;
        private AliasRoutingConfiguration routingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
            this.routingConfig(model.routingConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAliasRequest build() {
            return new CreateAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAliasRequest> {
        public Builder functionName(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);

        public Builder routingConfig(AliasRoutingConfiguration var1);

        default public Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return this.routingConfig((AliasRoutingConfiguration)((AliasRoutingConfiguration.Builder)AliasRoutingConfiguration.builder().applyMutation(routingConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

