/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends LambdaRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutResourcePolicyRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(PutResourcePolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(PutResourcePolicyRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            POLICY_FIELD, REVISION_ID_FIELD));

    private final String resourceArn;

    private final String policy;

    private final String revisionId;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.policy = builder.policy;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function you want to add the policy to. You can use either a qualified or
     * an unqualified ARN, but the value you specify must be a complete ARN and wildcard characters are not accepted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function you want to add the policy to. You can use either a
     *         qualified or an unqualified ARN, but the value you specify must be a complete ARN and wildcard characters
     *         are not accepted.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The JSON resource-based policy you want to add to your function.
     * </p>
     * <p>
     * To learn more about creating resource-based policies for controlling access to Lambda, see <a
     * href="https://docs.aws.amazon.com/">Working with resource-based IAM policies in Lambda</a> in the <i>Lambda
     * Developer Guide</i>.
     * </p>
     * 
     * @return The JSON resource-based policy you want to add to your function.</p>
     *         <p>
     *         To learn more about creating resource-based policies for controlling access to Lambda, see <a
     *         href="https://docs.aws.amazon.com/">Working with resource-based IAM policies in Lambda</a> in the
     *         <i>Lambda Developer Guide</i>.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * Replace the existing policy only if its revision ID matches the string you specify. To find the revision ID of
     * the policy currently attached to your function, use the <a>GetResourcePolicy</a> action.
     * </p>
     * 
     * @return Replace the existing policy only if its revision ID matches the string you specify. To find the revision
     *         ID of the policy currently attached to your function, use the <a>GetResourcePolicy</a> action.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(policy(), other.policy())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("ResourceArn", resourceArn()).add("Policy", policy())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function you want to add the policy to. You can use either a qualified
         * or an unqualified ARN, but the value you specify must be a complete ARN and wildcard characters are not
         * accepted.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the function you want to add the policy to. You can use either a
         *        qualified or an unqualified ARN, but the value you specify must be a complete ARN and wildcard
         *        characters are not accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The JSON resource-based policy you want to add to your function.
         * </p>
         * <p>
         * To learn more about creating resource-based policies for controlling access to Lambda, see <a
         * href="https://docs.aws.amazon.com/">Working with resource-based IAM policies in Lambda</a> in the <i>Lambda
         * Developer Guide</i>.
         * </p>
         * 
         * @param policy
         *        The JSON resource-based policy you want to add to your function.</p>
         *        <p>
         *        To learn more about creating resource-based policies for controlling access to Lambda, see <a
         *        href="https://docs.aws.amazon.com/">Working with resource-based IAM policies in Lambda</a> in the
         *        <i>Lambda Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * Replace the existing policy only if its revision ID matches the string you specify. To find the revision ID
         * of the policy currently attached to your function, use the <a>GetResourcePolicy</a> action.
         * </p>
         * 
         * @param revisionId
         *        Replace the existing policy only if its revision ID matches the string you specify. To find the
         *        revision ID of the policy currently attached to your function, use the <a>GetResourcePolicy</a>
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String policy;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            policy(model.policy);
            revisionId(model.revisionId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
