/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountSettingsResponse extends LambdaResponse implements
        ToCopyableBuilder<GetAccountSettingsResponse.Builder, GetAccountSettingsResponse> {
    private static final SdkField<AccountLimit> ACCOUNT_LIMIT_FIELD = SdkField.<AccountLimit> builder(MarshallingType.SDK_POJO)
            .memberName("AccountLimit").getter(getter(GetAccountSettingsResponse::accountLimit))
            .setter(setter(Builder::accountLimit)).constructor(AccountLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLimit").build()).build();

    private static final SdkField<AccountUsage> ACCOUNT_USAGE_FIELD = SdkField.<AccountUsage> builder(MarshallingType.SDK_POJO)
            .memberName("AccountUsage").getter(getter(GetAccountSettingsResponse::accountUsage))
            .setter(setter(Builder::accountUsage)).constructor(AccountUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LIMIT_FIELD,
            ACCOUNT_USAGE_FIELD));

    private final AccountLimit accountLimit;

    private final AccountUsage accountUsage;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLimit = builder.accountLimit;
        this.accountUsage = builder.accountUsage;
    }

    /**
     * <p>
     * Limits that are related to concurrency and code storage.
     * </p>
     * 
     * @return Limits that are related to concurrency and code storage.
     */
    public final AccountLimit accountLimit() {
        return accountLimit;
    }

    /**
     * <p>
     * The number of functions and amount of storage in use.
     * </p>
     * 
     * @return The number of functions and amount of storage in use.
     */
    public final AccountUsage accountUsage() {
        return accountUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountLimit());
        hashCode = 31 * hashCode + Objects.hashCode(accountUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse) obj;
        return Objects.equals(accountLimit(), other.accountLimit()) && Objects.equals(accountUsage(), other.accountUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountSettingsResponse").add("AccountLimit", accountLimit())
                .add("AccountUsage", accountUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountLimit":
            return Optional.ofNullable(clazz.cast(accountLimit()));
        case "AccountUsage":
            return Optional.ofNullable(clazz.cast(accountUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountSettingsResponse, T> g) {
        return obj -> g.apply((GetAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountSettingsResponse> {
        /**
         * <p>
         * Limits that are related to concurrency and code storage.
         * </p>
         * 
         * @param accountLimit
         *        Limits that are related to concurrency and code storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLimit(AccountLimit accountLimit);

        /**
         * <p>
         * Limits that are related to concurrency and code storage.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountLimit.Builder} avoiding the need to
         * create one manually via {@link AccountLimit#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountLimit.Builder#build()} is called immediately and its
         * result is passed to {@link #accountLimit(AccountLimit)}.
         * 
         * @param accountLimit
         *        a consumer that will call methods on {@link AccountLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLimit(AccountLimit)
         */
        default Builder accountLimit(Consumer<AccountLimit.Builder> accountLimit) {
            return accountLimit(AccountLimit.builder().applyMutation(accountLimit).build());
        }

        /**
         * <p>
         * The number of functions and amount of storage in use.
         * </p>
         * 
         * @param accountUsage
         *        The number of functions and amount of storage in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountUsage(AccountUsage accountUsage);

        /**
         * <p>
         * The number of functions and amount of storage in use.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountUsage.Builder} avoiding the need to
         * create one manually via {@link AccountUsage#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountUsage.Builder#build()} is called immediately and its
         * result is passed to {@link #accountUsage(AccountUsage)}.
         * 
         * @param accountUsage
         *        a consumer that will call methods on {@link AccountUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountUsage(AccountUsage)
         */
        default Builder accountUsage(Consumer<AccountUsage.Builder> accountUsage) {
            return accountUsage(AccountUsage.builder().applyMutation(accountUsage).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private AccountLimit accountLimit;

        private AccountUsage accountUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            super(model);
            accountLimit(model.accountLimit);
            accountUsage(model.accountUsage);
        }

        public final AccountLimit.Builder getAccountLimit() {
            return accountLimit != null ? accountLimit.toBuilder() : null;
        }

        public final void setAccountLimit(AccountLimit.BuilderImpl accountLimit) {
            this.accountLimit = accountLimit != null ? accountLimit.build() : null;
        }

        @Override
        @Transient
        public final Builder accountLimit(AccountLimit accountLimit) {
            this.accountLimit = accountLimit;
            return this;
        }

        public final AccountUsage.Builder getAccountUsage() {
            return accountUsage != null ? accountUsage.toBuilder() : null;
        }

        public final void setAccountUsage(AccountUsage.BuilderImpl accountUsage) {
            this.accountUsage = accountUsage != null ? accountUsage.build() : null;
        }

        @Override
        @Transient
        public final Builder accountUsage(AccountUsage accountUsage) {
            this.accountUsage = accountUsage;
            return this;
        }

        @Override
        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
