/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProvisionedConcurrencyConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, PutProvisionedConcurrencyConfigResponse> {
    private static final SdkField<Integer> REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestedProvisionedConcurrentExecutions").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::requestedProvisionedConcurrentExecutions)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::requestedProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<Integer> AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableProvisionedConcurrentExecutions").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::availableProvisionedConcurrentExecutions)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::availableProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<Integer> ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedProvisionedConcurrentExecutions").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::allocatedProvisionedConcurrentExecutions)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::allocatedProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::statusAsString)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::statusReason)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(PutProvisionedConcurrencyConfigResponse.getter(PutProvisionedConcurrencyConfigResponse::lastModified)).setter(PutProvisionedConcurrencyConfigResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_MODIFIED_FIELD));
    private final Integer requestedProvisionedConcurrentExecutions;
    private final Integer availableProvisionedConcurrentExecutions;
    private final Integer allocatedProvisionedConcurrentExecutions;
    private final String status;
    private final String statusReason;
    private final String lastModified;

    private PutProvisionedConcurrencyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.requestedProvisionedConcurrentExecutions = builder.requestedProvisionedConcurrentExecutions;
        this.availableProvisionedConcurrentExecutions = builder.availableProvisionedConcurrentExecutions;
        this.allocatedProvisionedConcurrentExecutions = builder.allocatedProvisionedConcurrentExecutions;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModified = builder.lastModified;
    }

    public final Integer requestedProvisionedConcurrentExecutions() {
        return this.requestedProvisionedConcurrentExecutions;
    }

    public final Integer availableProvisionedConcurrentExecutions() {
        return this.availableProvisionedConcurrentExecutions;
    }

    public final Integer allocatedProvisionedConcurrentExecutions() {
        return this.allocatedProvisionedConcurrentExecutions;
    }

    public final ProvisionedConcurrencyStatusEnum status() {
        return ProvisionedConcurrencyStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProvisionedConcurrencyConfigResponse)) {
            return false;
        }
        PutProvisionedConcurrencyConfigResponse other = (PutProvisionedConcurrencyConfigResponse)((Object)obj);
        return Objects.equals(this.requestedProvisionedConcurrentExecutions(), other.requestedProvisionedConcurrentExecutions()) && Objects.equals(this.availableProvisionedConcurrentExecutions(), other.availableProvisionedConcurrentExecutions()) && Objects.equals(this.allocatedProvisionedConcurrentExecutions(), other.allocatedProvisionedConcurrentExecutions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"PutProvisionedConcurrencyConfigResponse").add("RequestedProvisionedConcurrentExecutions", (Object)this.requestedProvisionedConcurrentExecutions()).add("AvailableProvisionedConcurrentExecutions", (Object)this.availableProvisionedConcurrentExecutions()).add("AllocatedProvisionedConcurrentExecutions", (Object)this.allocatedProvisionedConcurrentExecutions()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestedProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.requestedProvisionedConcurrentExecutions()));
            }
            case "AvailableProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.availableProvisionedConcurrentExecutions()));
            }
            case "AllocatedProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.allocatedProvisionedConcurrentExecutions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProvisionedConcurrencyConfigResponse, T> g) {
        return obj -> g.apply((PutProvisionedConcurrencyConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private Integer requestedProvisionedConcurrentExecutions;
        private Integer availableProvisionedConcurrentExecutions;
        private Integer allocatedProvisionedConcurrentExecutions;
        private String status;
        private String statusReason;
        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProvisionedConcurrencyConfigResponse model) {
            super(model);
            this.requestedProvisionedConcurrentExecutions(model.requestedProvisionedConcurrentExecutions);
            this.availableProvisionedConcurrentExecutions(model.availableProvisionedConcurrentExecutions);
            this.allocatedProvisionedConcurrentExecutions(model.allocatedProvisionedConcurrentExecutions);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.lastModified(model.lastModified);
        }

        public final Integer getRequestedProvisionedConcurrentExecutions() {
            return this.requestedProvisionedConcurrentExecutions;
        }

        public final void setRequestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
        }

        @Override
        @Transient
        public final Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAvailableProvisionedConcurrentExecutions() {
            return this.availableProvisionedConcurrentExecutions;
        }

        public final void setAvailableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
        }

        @Override
        @Transient
        public final Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAllocatedProvisionedConcurrentExecutions() {
            return this.allocatedProvisionedConcurrentExecutions;
        }

        public final void setAllocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
        }

        @Override
        @Transient
        public final Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ProvisionedConcurrencyStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        @Transient
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public PutProvisionedConcurrencyConfigResponse build() {
            return new PutProvisionedConcurrencyConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProvisionedConcurrencyConfigResponse> {
        public Builder requestedProvisionedConcurrentExecutions(Integer var1);

        public Builder availableProvisionedConcurrentExecutions(Integer var1);

        public Builder allocatedProvisionedConcurrentExecutions(Integer var1);

        public Builder status(String var1);

        public Builder status(ProvisionedConcurrencyStatusEnum var1);

        public Builder statusReason(String var1);

        public Builder lastModified(String var1);
    }
}

