/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLayerVersionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, DeleteLayerVersionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerName").getter(DeleteLayerVersionRequest.getter(DeleteLayerVersionRequest::layerName)).setter(DeleteLayerVersionRequest.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(DeleteLayerVersionRequest.getter(DeleteLayerVersionRequest::versionNumber)).setter(DeleteLayerVersionRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD, VERSION_NUMBER_FIELD));
    private final String layerName;
    private final Long versionNumber;

    private DeleteLayerVersionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.versionNumber = builder.versionNumber;
    }

    public final String layerName() {
        return this.layerName;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLayerVersionRequest)) {
            return false;
        }
        DeleteLayerVersionRequest other = (DeleteLayerVersionRequest)((Object)obj);
        return Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLayerVersionRequest").add("LayerName", (Object)this.layerName()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLayerVersionRequest, T> g) {
        return obj -> g.apply((DeleteLayerVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String layerName;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLayerVersionRequest model) {
            super(model);
            this.layerName(model.layerName);
            this.versionNumber(model.versionNumber);
        }

        public final String getLayerName() {
            return this.layerName;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        @Override
        @Transient
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        @Transient
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLayerVersionRequest build() {
            return new DeleteLayerVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLayerVersionRequest> {
        public Builder layerName(String var1);

        public Builder versionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

