/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of signing profiles that can sign a code package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowedPublishers implements SdkPojo, Serializable,
        ToCopyableBuilder<AllowedPublishers.Builder, AllowedPublishers> {
    private static final SdkField<List<String>> SIGNING_PROFILE_VERSION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SigningProfileVersionArns")
            .getter(getter(AllowedPublishers::signingProfileVersionArns))
            .setter(setter(Builder::signingProfileVersionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProfileVersionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SIGNING_PROFILE_VERSION_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> signingProfileVersionArns;

    private AllowedPublishers(BuilderImpl builder) {
        this.signingProfileVersionArns = builder.signingProfileVersionArns;
    }

    /**
     * Returns true if the SigningProfileVersionArns property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSigningProfileVersionArns() {
        return signingProfileVersionArns != null && !(signingProfileVersionArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can
     * sign a code package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSigningProfileVersionArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user
     *         who can sign a code package.
     */
    public final List<String> signingProfileVersionArns() {
        return signingProfileVersionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSigningProfileVersionArns() ? signingProfileVersionArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedPublishers)) {
            return false;
        }
        AllowedPublishers other = (AllowedPublishers) obj;
        return hasSigningProfileVersionArns() == other.hasSigningProfileVersionArns()
                && Objects.equals(signingProfileVersionArns(), other.signingProfileVersionArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowedPublishers")
                .add("SigningProfileVersionArns", hasSigningProfileVersionArns() ? signingProfileVersionArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SigningProfileVersionArns":
            return Optional.ofNullable(clazz.cast(signingProfileVersionArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowedPublishers, T> g) {
        return obj -> g.apply((AllowedPublishers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowedPublishers> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who
         * can sign a code package.
         * </p>
         * 
         * @param signingProfileVersionArns
         *        The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted
         *        user who can sign a code package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileVersionArns(Collection<String> signingProfileVersionArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who
         * can sign a code package.
         * </p>
         * 
         * @param signingProfileVersionArns
         *        The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted
         *        user who can sign a code package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileVersionArns(String... signingProfileVersionArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> signingProfileVersionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedPublishers model) {
            signingProfileVersionArns(model.signingProfileVersionArns);
        }

        public final Collection<String> getSigningProfileVersionArns() {
            if (signingProfileVersionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return signingProfileVersionArns;
        }

        @Override
        public final Builder signingProfileVersionArns(Collection<String> signingProfileVersionArns) {
            this.signingProfileVersionArns = SigningProfileVersionArnsCopier.copy(signingProfileVersionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingProfileVersionArns(String... signingProfileVersionArns) {
            signingProfileVersionArns(Arrays.asList(signingProfileVersionArns));
            return this;
        }

        public final void setSigningProfileVersionArns(Collection<String> signingProfileVersionArns) {
            this.signingProfileVersionArns = SigningProfileVersionArnsCopier.copy(signingProfileVersionArns);
        }

        @Override
        public AllowedPublishers build() {
            return new AllowedPublishers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
