/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.lambda.model.AccountLimit;
import software.amazon.awssdk.services.lambda.model.AccountUsage;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountSettingsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetAccountSettingsResponse> {
    private final AccountLimit accountLimit;
    private final AccountUsage accountUsage;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLimit = builder.accountLimit;
        this.accountUsage = builder.accountUsage;
    }

    public AccountLimit accountLimit() {
        return this.accountLimit;
    }

    public AccountUsage accountUsage() {
        return this.accountUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountUsage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse)((Object)obj);
        return Objects.equals(this.accountLimit(), other.accountLimit()) && Objects.equals(this.accountUsage(), other.accountUsage());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountSettingsResponse").add("AccountLimit", (Object)this.accountLimit()).add("AccountUsage", (Object)this.accountUsage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLimit": {
                return Optional.of(clazz.cast(this.accountLimit()));
            }
            case "AccountUsage": {
                return Optional.of(clazz.cast(this.accountUsage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private AccountLimit accountLimit;
        private AccountUsage accountUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            this.accountLimit(model.accountLimit);
            this.accountUsage(model.accountUsage);
        }

        public final AccountLimit.Builder getAccountLimit() {
            return this.accountLimit != null ? this.accountLimit.toBuilder() : null;
        }

        @Override
        public final Builder accountLimit(AccountLimit accountLimit) {
            this.accountLimit = accountLimit;
            return this;
        }

        public final void setAccountLimit(AccountLimit.BuilderImpl accountLimit) {
            this.accountLimit = accountLimit != null ? accountLimit.build() : null;
        }

        public final AccountUsage.Builder getAccountUsage() {
            return this.accountUsage != null ? this.accountUsage.toBuilder() : null;
        }

        @Override
        public final Builder accountUsage(AccountUsage accountUsage) {
            this.accountUsage = accountUsage;
            return this;
        }

        public final void setAccountUsage(AccountUsage.BuilderImpl accountUsage) {
            this.accountUsage = accountUsage != null ? accountUsage.build() : null;
        }

        @Override
        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    CopyableBuilder<Builder, GetAccountSettingsResponse> {
        public Builder accountLimit(AccountLimit var1);

        default public Builder accountLimit(Consumer<AccountLimit.Builder> accountLimit) {
            return this.accountLimit((AccountLimit)((AccountLimit.Builder)AccountLimit.builder().apply(accountLimit)).build());
        }

        public Builder accountUsage(AccountUsage var1);

        default public Builder accountUsage(Consumer<AccountUsage.Builder> accountUsage) {
            return this.accountUsage((AccountUsage)((AccountUsage.Builder)AccountUsage.builder().apply(accountUsage)).build());
        }
    }
}

