/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lambda.model.FunctionVersion;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFunctionsRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, ListFunctionsRequest> {
    private final String masterRegion;
    private final String functionVersion;
    private final String marker;
    private final Integer maxItems;

    private ListFunctionsRequest(BuilderImpl builder) {
        super(builder);
        this.masterRegion = builder.masterRegion;
        this.functionVersion = builder.functionVersion;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public String masterRegion() {
        return this.masterRegion;
    }

    public FunctionVersion functionVersion() {
        return FunctionVersion.fromValue(this.functionVersion);
    }

    public String functionVersionString() {
        return this.functionVersion;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.masterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsRequest)) {
            return false;
        }
        ListFunctionsRequest other = (ListFunctionsRequest)((Object)obj);
        return Objects.equals(this.masterRegion(), other.masterRegion()) && Objects.equals(this.functionVersionString(), other.functionVersionString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListFunctionsRequest").add("MasterRegion", (Object)this.masterRegion()).add("FunctionVersion", (Object)this.functionVersionString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterRegion": {
                return Optional.of(clazz.cast(this.masterRegion()));
            }
            case "FunctionVersion": {
                return Optional.of(clazz.cast(this.functionVersionString()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String masterRegion;
        private String functionVersion;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsRequest model) {
            this.masterRegion(model.masterRegion);
            this.functionVersion(model.functionVersion);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getMasterRegion() {
            return this.masterRegion;
        }

        @Override
        public final Builder masterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
            return this;
        }

        public final void setMasterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        @Override
        public final Builder functionVersion(FunctionVersion functionVersion) {
            this.functionVersion(functionVersion.toString());
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListFunctionsRequest build() {
            return new ListFunctionsRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, ListFunctionsRequest> {
        public Builder masterRegion(String var1);

        public Builder functionVersion(String var1);

        public Builder functionVersion(FunctionVersion var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

