/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;

@SdkInternalApi
public class InvokeRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> INVOCATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Invocation-Type").build();
    private static final MarshallingInfo<String> LOGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Log-Type").build();
    private static final MarshallingInfo<String> CLIENTCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Client-Context").build();
    private static final MarshallingInfo<ByteBuffer> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").build();
    private static final InvokeRequestModelMarshaller INSTANCE = new InvokeRequestModelMarshaller();

    public static InvokeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InvokeRequest invokeRequest, ProtocolMarshaller protocolMarshaller) {
        if (invokeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)invokeRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.invocationTypeString(), INVOCATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.logTypeString(), LOGTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.clientContext(), CLIENTCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.payload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.qualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

