/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishVersionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PublishVersionRequest> {
    private final String functionName;
    private final String codeSha256;
    private final String description;

    private PublishVersionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.codeSha256 = builder.codeSha256;
        this.description = builder.description;
    }

    public String functionName() {
        return this.functionName;
    }

    public String codeSha256() {
        return this.codeSha256;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishVersionRequest)) {
            return false;
        }
        PublishVersionRequest other = (PublishVersionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.codeSha256() != null) {
            sb.append("CodeSha256: ").append(this.codeSha256()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "CodeSha256": {
                return Optional.of(clazz.cast(this.codeSha256()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String codeSha256;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishVersionRequest model) {
            this.functionName(model.functionName);
            this.codeSha256(model.codeSha256);
            this.description(model.description);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PublishVersionRequest build() {
            return new PublishVersionRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, PublishVersionRequest> {
        public Builder functionName(String var1);

        public Builder codeSha256(String var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

