/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.TracingMode;
import software.amazon.awssdk.services.lambda.transform.TracingConfigResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TracingConfigResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, TracingConfigResponse> {
    private final String mode;

    private TracingConfigResponse(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    public TracingMode mode() {
        return TracingMode.fromValue(this.mode);
    }

    public String modeString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracingConfigResponse)) {
            return false;
        }
        TracingConfigResponse other = (TracingConfigResponse)obj;
        return Objects.equals(this.modeString(), other.modeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.modeString() != null) {
            sb.append("Mode: ").append(this.modeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.of(clazz.cast(this.modeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TracingConfigResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(TracingConfigResponse model) {
            this.mode(model.mode);
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(TracingMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public TracingConfigResponse build() {
            return new TracingConfigResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TracingConfigResponse> {
        public Builder mode(String var1);

        public Builder mode(TracingMode var1);
    }
}

