/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TracingConfigResponse;
import software.amazon.awssdk.services.lambda.model.VpcConfigResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishVersionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PublishVersionResponse> {
    private final String functionName;
    private final String functionArn;
    private final String runtime;
    private final String role;
    private final String handler;
    private final Long codeSize;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final String lastModified;
    private final String codeSha256;
    private final String version;
    private final VpcConfigResponse vpcConfig;
    private final DeadLetterConfig deadLetterConfig;
    private final EnvironmentResponse environment;
    private final String kmsKeyArn;
    private final TracingConfigResponse tracingConfig;
    private final String masterArn;

    private PublishVersionResponse(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.functionArn = builder.functionArn;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.codeSize = builder.codeSize;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.lastModified = builder.lastModified;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.vpcConfig = builder.vpcConfig;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.masterArn = builder.masterArn;
    }

    public String functionName() {
        return this.functionName;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public String runtimeString() {
        return this.runtime;
    }

    public String role() {
        return this.role;
    }

    public String handler() {
        return this.handler;
    }

    public Long codeSize() {
        return this.codeSize;
    }

    public String description() {
        return this.description;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public String lastModified() {
        return this.lastModified;
    }

    public String codeSha256() {
        return this.codeSha256;
    }

    public String version() {
        return this.version;
    }

    public VpcConfigResponse vpcConfig() {
        return this.vpcConfig;
    }

    public DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public EnvironmentResponse environment() {
        return this.environment;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public TracingConfigResponse tracingConfig() {
        return this.tracingConfig;
    }

    public String masterArn() {
        return this.masterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishVersionResponse)) {
            return false;
        }
        PublishVersionResponse other = (PublishVersionResponse)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.runtimeString(), other.runtimeString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig()) && Objects.equals(this.masterArn(), other.masterArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.functionArn() != null) {
            sb.append("FunctionArn: ").append(this.functionArn()).append(",");
        }
        if (this.runtimeString() != null) {
            sb.append("Runtime: ").append(this.runtimeString()).append(",");
        }
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.handler() != null) {
            sb.append("Handler: ").append(this.handler()).append(",");
        }
        if (this.codeSize() != null) {
            sb.append("CodeSize: ").append(this.codeSize()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (this.memorySize() != null) {
            sb.append("MemorySize: ").append(this.memorySize()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.codeSha256() != null) {
            sb.append("CodeSha256: ").append(this.codeSha256()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.deadLetterConfig() != null) {
            sb.append("DeadLetterConfig: ").append(this.deadLetterConfig()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.kmsKeyArn() != null) {
            sb.append("KMSKeyArn: ").append(this.kmsKeyArn()).append(",");
        }
        if (this.tracingConfig() != null) {
            sb.append("TracingConfig: ").append(this.tracingConfig()).append(",");
        }
        if (this.masterArn() != null) {
            sb.append("MasterArn: ").append(this.masterArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "FunctionArn": {
                return Optional.of(clazz.cast(this.functionArn()));
            }
            case "Runtime": {
                return Optional.of(clazz.cast(this.runtimeString()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.of(clazz.cast(this.handler()));
            }
            case "CodeSize": {
                return Optional.of(clazz.cast(this.codeSize()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.of(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.of(clazz.cast(this.memorySize()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "CodeSha256": {
                return Optional.of(clazz.cast(this.codeSha256()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "DeadLetterConfig": {
                return Optional.of(clazz.cast(this.deadLetterConfig()));
            }
            case "Environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
            case "KMSKeyArn": {
                return Optional.of(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.of(clazz.cast(this.tracingConfig()));
            }
            case "MasterArn": {
                return Optional.of(clazz.cast(this.masterArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String functionArn;
        private String runtime;
        private String role;
        private String handler;
        private Long codeSize;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private String lastModified;
        private String codeSha256;
        private String version;
        private VpcConfigResponse vpcConfig;
        private DeadLetterConfig deadLetterConfig;
        private EnvironmentResponse environment;
        private String kmsKeyArn;
        private TracingConfigResponse tracingConfig;
        private String masterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishVersionResponse model) {
            this.functionName(model.functionName);
            this.functionArn(model.functionArn);
            this.runtime(model.runtime);
            this.role(model.role);
            this.handler(model.handler);
            this.codeSize(model.codeSize);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.lastModified(model.lastModified);
            this.codeSha256(model.codeSha256);
            this.version(model.version);
            this.vpcConfig(model.vpcConfig);
            this.deadLetterConfig(model.deadLetterConfig);
            this.environment(model.environment);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
            this.masterArn(model.masterArn);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final VpcConfigResponse.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final EnvironmentResponse.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(EnvironmentResponse environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(EnvironmentResponse.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getKMSKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKMSKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfigResponse.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfigResponse tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfigResponse.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final String getMasterArn() {
            return this.masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        public PublishVersionResponse build() {
            return new PublishVersionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PublishVersionResponse> {
        public Builder functionName(String var1);

        public Builder functionArn(String var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder codeSize(Long var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder lastModified(String var1);

        public Builder codeSha256(String var1);

        public Builder version(String var1);

        public Builder vpcConfig(VpcConfigResponse var1);

        default public Builder vpcConfig(Consumer<VpcConfigResponse.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigResponse)((VpcConfigResponse.Builder)VpcConfigResponse.builder().apply(vpcConfig)).build());
        }

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().apply(deadLetterConfig)).build());
        }

        public Builder environment(EnvironmentResponse var1);

        default public Builder environment(Consumer<EnvironmentResponse.Builder> environment) {
            return this.environment((EnvironmentResponse)((EnvironmentResponse.Builder)EnvironmentResponse.builder().apply(environment)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfigResponse var1);

        default public Builder tracingConfig(Consumer<TracingConfigResponse.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfigResponse)((TracingConfigResponse.Builder)TracingConfigResponse.builder().apply(tracingConfig)).build());
        }

        public Builder masterArn(String var1);
    }
}

