/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFunctionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListFunctionsResponse> {
    private final String nextMarker;
    private final List<FunctionConfiguration> functions;

    private ListFunctionsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.functions = builder.functions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<FunctionConfiguration> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.functions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.functions(), other.functions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.functions() != null) {
            sb.append("Functions: ").append(this.functions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "Functions": {
                return Optional.of(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<FunctionConfiguration> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            this.nextMarker(model.nextMarker);
            this.functions(model.functions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FunctionConfiguration.Builder> getFunctions() {
            return this.functions != null ? (Collection)this.functions.stream().map(FunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionListCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(FunctionConfiguration ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<FunctionConfiguration.BuilderImpl> functions) {
            this.functions = FunctionListCopier.copyFromBuilder(functions);
        }

        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListFunctionsResponse> {
        public Builder nextMarker(String var1);

        public Builder functions(Collection<FunctionConfiguration> var1);

        public Builder functions(FunctionConfiguration ... var1);
    }
}

