/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.AccountLimit;
import software.amazon.awssdk.services.lambda.model.AccountUsage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountSettingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetAccountSettingsResponse> {
    private final AccountLimit accountLimit;
    private final AccountUsage accountUsage;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        this.accountLimit = builder.accountLimit;
        this.accountUsage = builder.accountUsage;
    }

    public AccountLimit accountLimit() {
        return this.accountLimit;
    }

    public AccountUsage accountUsage() {
        return this.accountUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountLimit() == null ? 0 : this.accountLimit().hashCode());
        hashCode = 31 * hashCode + (this.accountUsage() == null ? 0 : this.accountUsage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse)((Object)obj);
        if (other.accountLimit() == null ^ this.accountLimit() == null) {
            return false;
        }
        if (other.accountLimit() != null && !other.accountLimit().equals(this.accountLimit())) {
            return false;
        }
        if (other.accountUsage() == null ^ this.accountUsage() == null) {
            return false;
        }
        return other.accountUsage() == null || other.accountUsage().equals(this.accountUsage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountLimit() != null) {
            sb.append("AccountLimit: ").append(this.accountLimit()).append(",");
        }
        if (this.accountUsage() != null) {
            sb.append("AccountUsage: ").append(this.accountUsage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLimit": {
                return Optional.of(clazz.cast(this.accountLimit()));
            }
            case "AccountUsage": {
                return Optional.of(clazz.cast(this.accountUsage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private AccountLimit accountLimit;
        private AccountUsage accountUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            this.accountLimit(model.accountLimit);
            this.accountUsage(model.accountUsage);
        }

        public final AccountLimit.Builder getAccountLimit() {
            return this.accountLimit != null ? this.accountLimit.toBuilder() : null;
        }

        @Override
        public final Builder accountLimit(AccountLimit accountLimit) {
            this.accountLimit = accountLimit;
            return this;
        }

        public final void setAccountLimit(AccountLimit.BuilderImpl accountLimit) {
            this.accountLimit = accountLimit != null ? accountLimit.build() : null;
        }

        public final AccountUsage.Builder getAccountUsage() {
            return this.accountUsage != null ? this.accountUsage.toBuilder() : null;
        }

        @Override
        public final Builder accountUsage(AccountUsage accountUsage) {
            this.accountUsage = accountUsage;
            return this;
        }

        public final void setAccountUsage(AccountUsage.BuilderImpl accountUsage) {
            this.accountUsage = accountUsage != null ? accountUsage.build() : null;
        }

        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAccountSettingsResponse> {
        public Builder accountLimit(AccountLimit var1);

        public Builder accountUsage(AccountUsage var1);
    }
}

