/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEventSourceMappingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListEventSourceMappingsResponse> {
    private final String nextMarker;
    private final List<EventSourceMappingConfiguration> eventSourceMappings;

    private ListEventSourceMappingsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.eventSourceMappings = builder.eventSourceMappings;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<EventSourceMappingConfiguration> eventSourceMappings() {
        return this.eventSourceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.eventSourceMappings() == null ? 0 : this.eventSourceMappings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourceMappingsResponse)) {
            return false;
        }
        ListEventSourceMappingsResponse other = (ListEventSourceMappingsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.eventSourceMappings() == null ^ this.eventSourceMappings() == null) {
            return false;
        }
        return other.eventSourceMappings() == null || other.eventSourceMappings().equals(this.eventSourceMappings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.eventSourceMappings() != null) {
            sb.append("EventSourceMappings: ").append(this.eventSourceMappings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<EventSourceMappingConfiguration> eventSourceMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourceMappingsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setEventSourceMappings(model.eventSourceMappings);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<EventSourceMappingConfiguration> getEventSourceMappings() {
            return this.eventSourceMappings;
        }

        @Override
        public final Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(EventSourceMappingConfiguration ... eventSourceMappings) {
            this.eventSourceMappings(Arrays.asList(eventSourceMappings));
            return this;
        }

        public final void setEventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
        }

        public ListEventSourceMappingsResponse build() {
            return new ListEventSourceMappingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListEventSourceMappingsResponse> {
        public Builder nextMarker(String var1);

        public Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> var1);

        public Builder eventSourceMappings(EventSourceMappingConfiguration ... var1);
    }
}

