/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.VpcConfig;

@SdkInternalApi
public class VpcConfigMarshaller {
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final VpcConfigMarshaller INSTANCE = new VpcConfigMarshaller();

    public static VpcConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VpcConfig vpcConfig, ProtocolMarshaller protocolMarshaller) {
        if (vpcConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(vpcConfig.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(vpcConfig.securityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

