/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.VpcConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFunctionConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
    private final String functionName;
    private final String role;
    private final String handler;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final VpcConfig vpcConfig;
    private final Environment environment;
    private final String runtime;
    private final DeadLetterConfig deadLetterConfig;
    private final String kmsKeyArn;
    private final TracingConfig tracingConfig;

    private UpdateFunctionConfigurationRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.role = builder.role;
        this.handler = builder.handler;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.vpcConfig = builder.vpcConfig;
        this.environment = builder.environment;
        this.runtime = builder.runtime;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
    }

    public String functionName() {
        return this.functionName;
    }

    public String role() {
        return this.role;
    }

    public String handler() {
        return this.handler;
    }

    public String description() {
        return this.description;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Environment environment() {
        return this.environment;
    }

    public String runtime() {
        return this.runtime;
    }

    public DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public TracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.role() == null ? 0 : this.role().hashCode());
        hashCode = 31 * hashCode + (this.handler() == null ? 0 : this.handler().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.timeout() == null ? 0 : this.timeout().hashCode());
        hashCode = 31 * hashCode + (this.memorySize() == null ? 0 : this.memorySize().hashCode());
        hashCode = 31 * hashCode + (this.vpcConfig() == null ? 0 : this.vpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.runtime() == null ? 0 : this.runtime().hashCode());
        hashCode = 31 * hashCode + (this.deadLetterConfig() == null ? 0 : this.deadLetterConfig().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyArn() == null ? 0 : this.kmsKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.tracingConfig() == null ? 0 : this.tracingConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionConfigurationRequest)) {
            return false;
        }
        UpdateFunctionConfigurationRequest other = (UpdateFunctionConfigurationRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.role() == null ^ this.role() == null) {
            return false;
        }
        if (other.role() != null && !other.role().equals(this.role())) {
            return false;
        }
        if (other.handler() == null ^ this.handler() == null) {
            return false;
        }
        if (other.handler() != null && !other.handler().equals(this.handler())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.timeout() == null ^ this.timeout() == null) {
            return false;
        }
        if (other.timeout() != null && !other.timeout().equals(this.timeout())) {
            return false;
        }
        if (other.memorySize() == null ^ this.memorySize() == null) {
            return false;
        }
        if (other.memorySize() != null && !other.memorySize().equals(this.memorySize())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.runtime() == null ^ this.runtime() == null) {
            return false;
        }
        if (other.runtime() != null && !other.runtime().equals(this.runtime())) {
            return false;
        }
        if (other.deadLetterConfig() == null ^ this.deadLetterConfig() == null) {
            return false;
        }
        if (other.deadLetterConfig() != null && !other.deadLetterConfig().equals(this.deadLetterConfig())) {
            return false;
        }
        if (other.kmsKeyArn() == null ^ this.kmsKeyArn() == null) {
            return false;
        }
        if (other.kmsKeyArn() != null && !other.kmsKeyArn().equals(this.kmsKeyArn())) {
            return false;
        }
        if (other.tracingConfig() == null ^ this.tracingConfig() == null) {
            return false;
        }
        return other.tracingConfig() == null || other.tracingConfig().equals(this.tracingConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.handler() != null) {
            sb.append("Handler: ").append(this.handler()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (this.memorySize() != null) {
            sb.append("MemorySize: ").append(this.memorySize()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.runtime() != null) {
            sb.append("Runtime: ").append(this.runtime()).append(",");
        }
        if (this.deadLetterConfig() != null) {
            sb.append("DeadLetterConfig: ").append(this.deadLetterConfig()).append(",");
        }
        if (this.kmsKeyArn() != null) {
            sb.append("KMSKeyArn: ").append(this.kmsKeyArn()).append(",");
        }
        if (this.tracingConfig() != null) {
            sb.append("TracingConfig: ").append(this.tracingConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String role;
        private String handler;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private VpcConfig vpcConfig;
        private Environment environment;
        private String runtime;
        private DeadLetterConfig deadLetterConfig;
        private String kmsKeyArn;
        private TracingConfig tracingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionConfigurationRequest model) {
            this.setFunctionName(model.functionName);
            this.setRole(model.role);
            this.setHandler(model.handler);
            this.setDescription(model.description);
            this.setTimeout(model.timeout);
            this.setMemorySize(model.memorySize);
            this.setVpcConfig(model.vpcConfig);
            this.setEnvironment(model.environment);
            this.setRuntime(model.runtime);
            this.setDeadLetterConfig(model.deadLetterConfig);
            this.setKMSKeyArn(model.kmsKeyArn);
            this.setTracingConfig(model.tracingConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final VpcConfig getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
        }

        public final Environment getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final DeadLetterConfig getDeadLetterConfig() {
            return this.deadLetterConfig;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
        }

        public final String getKMSKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKMSKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig getTracingConfig() {
            return this.tracingConfig;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
        }

        public UpdateFunctionConfigurationRequest build() {
            return new UpdateFunctionConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
        public Builder functionName(String var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder vpcConfig(VpcConfig var1);

        public Builder environment(Environment var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfig var1);
    }
}

