/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PublishVersionRequest> {
    private final String functionName;
    private final String codeSha256;
    private final String description;

    private PublishVersionRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.codeSha256 = builder.codeSha256;
        this.description = builder.description;
    }

    public String functionName() {
        return this.functionName;
    }

    public String codeSha256() {
        return this.codeSha256;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.codeSha256() == null ? 0 : this.codeSha256().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishVersionRequest)) {
            return false;
        }
        PublishVersionRequest other = (PublishVersionRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.codeSha256() == null ^ this.codeSha256() == null) {
            return false;
        }
        if (other.codeSha256() != null && !other.codeSha256().equals(this.codeSha256())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.codeSha256() != null) {
            sb.append("CodeSha256: ").append(this.codeSha256()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String codeSha256;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishVersionRequest model) {
            this.setFunctionName(model.functionName);
            this.setCodeSha256(model.codeSha256);
            this.setDescription(model.description);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public PublishVersionRequest build() {
            return new PublishVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PublishVersionRequest> {
        public Builder functionName(String var1);

        public Builder codeSha256(String var1);

        public Builder description(String var1);
    }
}

